package csbase.client.applications.flowapplication.actions;

import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.util.Collection;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.CheckClipboardFlavorMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;

/**
 * Ao de menu popup que "cola" um n de fluxo previamente copiado, incluindo o
 * valor de seus parmetros.
 */
public class PasteElementsAction extends FlowApplicationAction implements
  FlavorListener {

  /**
   * Cria a ao.
   * 
   * @param application A aplicao construtura de fluxos.
   */
  public PasteElementsAction(FlowApplication application) {
    super(application, FlowApplicationUI.PASTE_NODE_ICON);
    updateEnabledStatus();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    FlowApplication application = getApplication();
    Workspace workspace = application.getWorkspace();
    final Graph graph = workspace.getGraph();
    final PasteMessage pasteMessage = new PasteMessage();
    pasteMessage.sendVS(graph);
    if (pasteMessage.getTransferable() != null) {
      pasteMessage.sendVO(graph);
      Collection<GraphElement> elements = pasteMessage.getAffectedElements();
      if (elements != null) {
        workspace.sendVO(new SelectElementsMessage(elements));
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void flavorsChanged(FlavorEvent e) {
    updateEnabledStatus();
  }

  /**
   * Habilita/desabilita a ao, dependendo do estado do grafo.
   * 
   */
  private void updateEnabledStatus() {
    FlowApplication application = getApplication();
    Workspace workspace = application.getWorkspace();
    Graph graph = workspace.getGraph();
    boolean canPaste =
      CheckClipboardFlavorMessage.canPasteFromClipboard(graph,
        FlowTransferable.DATA_FLAVOR);
    setEnabled(canPaste);
  }

}
