package csbase.client.applications.flowapplication.configurator;

import java.awt.Window;
import java.rmi.RemoteException;

import javax.swing.JComponent;

import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.ParameterView.Mode;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.view.flow.FlowAlgorithmConfiguratorPanel;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.kernel.ClientException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.validation.ValidationMode;

/**
 * Viso de configurador de fluxo de algoritmos.
 * 
 * @author lmoreira
 */
public final class FlowAlgorithmConfiguratorView extends
  AlgorithmConfiguratorView {
  /**
   * O componente principal.
   */
  private final FlowAlgorithmConfiguratorPanel mainComponent;

  /**
   * Cria uma viso de configurador de fluxo.
   * 
   * @param owner A janela que  pai desta viso (No aceita {@code null}).
   * @param configurator O configurador de fluxo.
   * @param mode Modo de visualizao do configurador. No aceita {@code null},
   *        os possveis valores so: {@link Mode#CONFIGURATION} ou
   *        {@link Mode#REPORT}
   * @param validationMode O modo de validao dos parmetros do configurador.
   * @throws ClientException em caso de erro na criao da viso.
   */
  public FlowAlgorithmConfiguratorView(Window owner,
    FlowAlgorithmConfigurator configurator, Mode mode,
    ValidationMode validationMode) throws ClientException {
    super(owner, configurator, mode, validationMode);
    mainComponent =
      new FlowAlgorithmConfiguratorPanel(owner, configurator, mode);
  }

  /**
   * {@inheritDoc}
   * 
   * @see FlowAlgorithmConfiguratorPanel#getConfigurator()
   */
  @Override
  public AlgorithmConfigurator getConfigurator() {
    return null == mainComponent ? super.getConfigurator() : mainComponent
      .getConfigurator();
  }

  /**
   * Cria uma viso para configurador de fluxos de algoritmos.
   * 
   * @param window A janela (No aceita {@code null}).
   * @param graph A viso do fluxo (No aceita {@code null}).
   * @param mode Modo de visualizao do configurador. No aceita {@code null},
   *        os possveis valores so: {@link Mode#CONFIGURATION} ou
   *        {@link Mode#REPORT}
   * @param validationMode O modo de validao dos parmetros do configurador.
   * @throws ClientException em caso de erro na criao da viso.
   */
  public FlowAlgorithmConfiguratorView(Window window, Graph graph,
    ParameterView.Mode mode, ValidationMode validationMode)
    throws ClientException {
    this(window, new FlowAlgorithmConfigurator(graph.toFlow()), mode,
      validationMode);
  }

  /**
   * Obtm a viso do fluxo.
   * 
   * @return A viso do fluxo.
   */
  public Graph getGraph() {
    return null == this.mainComponent ? null : this.mainComponent.getGraph();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean highlightValidationResult(ViewValidationResult result) {
    return mainComponent.highlightValidationResult(result);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ViewValidationResult validate(ValidationMode mode)
    throws RemoteException {
    return mainComponent.validate(mode);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public JComponent getMainComponent() {
    return mainComponent;
  }

  /**
   * Retorna o workspace onde o fluxo  desenhado.
   * 
   * @return o workspace onde o fluxo  desenhado.
   */
  public Workspace getWorkspace() {
    return null == this.mainComponent ? null : this.mainComponent
      .getWorkspace();
  }
}
