package csbase.client.applications.flowapplication.graph;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

/**
 * Define uma mesma largura para todos os ns do grafo.
 */
public class UniformSizeGraphLayout implements GraphLayout {

  /**
   * {@inheritDoc}
   */
  @Override
  public void doLayout(Graph graph) {
    double newWidth = 0;
    double newHeight = 0;
    Collection<GraphNode> nodeCollection = graph.getNodeCollection();
    // Encontra a menor dimenso que seja suficiente para todos os ns do grafo.
    for (GraphNode node : nodeCollection) {
      Dimension minimumSize = node.getMinimumSize();
      newWidth = Math.max(minimumSize.getWidth(), newWidth);
      newHeight = Math.max(minimumSize.getHeight(), newHeight);
    }
    // Aplica o tamanho em todos os ns, mantendo a posio do seu centro.
    for (GraphNode node : nodeCollection) {
      Rectangle2D previousBounds = node.getBounds2D();
      double centerX = previousBounds.getCenterX();
      double centerY = previousBounds.getCenterY();
      node.setBounds2D(node.getX(), node.getY(), newWidth, newHeight);
      /*
       * Reposiciona os ns somente depois de fazer o redimensionamento para
       * evitar que o clculo de ajuste  grade influencie no tamanho do n.
       */
      node.setLocation(new Point2D.Double(centerX, centerY));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canApplyLayout(Graph graph) {
    return true;
  }
}
