package csbase.client.project;

import javax.swing.ImageIcon;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.ApplicationImages;
import csbase.logic.ClientProjectFile;

/**
 * <p>
 * Essa classe deve ser utilizada para se obter propriedades de um
 * ClientProjectFile, mas que tenham semntica apenas no lado cliente.
 * </p>
 * 
 * <p>
 * Essas propriedades so cones e textos que so usados na exibio de um
 * ClientProjectFile na rvore de projetos (
 * {@link csbase.client.project.ProjectTree}), no painel de contedo de
 * diretrios {@link csbase.client.desktop.dircontents.DirectoryContentsPanel},
 * entre outros.
 * </p>
 * 
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 */
public final class ClientProjectFileProperties {
  /**
   * Obtm o cone associado a um arquivo de projeto, quando este arquivo no
   * est recortado.
   * 
   * @param file O arquivo de projeto.
   * 
   * @return O cone, ou null, quanto o arquivo est num estado desconhecido.
   */
  public static ImageIcon getImageIcon(ClientProjectFile file) {
    if (file.isMoving()) {
      return getCutImageIcon(file);
    }
    if (file.isDirectory()) {
      if (file.isUpdated()) {
        return ApplicationImages.ICON_FOLDER_16;
      }
      return ApplicationImages.ICON_FOLDEROUTOFDATE_16;
    }
    ClientProjectFileType fileType =
      ClientProjectFileType.getFileType(file.getType());
    if (file.isUnderConstruction()) {
      return fileType.getUnderConstructionIcon();
    }
    if (!file.isDirectory()) {
      return fileType.getBaseIcon();
    }
    return null;
  }

  /**
   * Obtm o cone associado a um arquivo de projeto quando ele est no modo
   * "recortado" para o clipboard.
   * 
   * @param file O arquivo de projeto.
   * 
   * @return O cone do arquivo.
   */
  public static ImageIcon getCutImageIcon(ClientProjectFile file) {
    if (file.isDirectory()) {
      return ApplicationImages.ICON_FOLDERCUT_16;
    }
    ClientProjectFileType fileType =
      ClientProjectFileType.getFileType(file.getType());
    return fileType.getCutIcon();
  }

  /**
   * Obtm a descrio do modo de acesso do arquivo.
   * 
   * @param file O arquivo de projeto.
   * 
   * @return A descrio do modo de acesso do arquivo, ou um espao em branco,
   *         caso o arquivo esteja num estado desconhecido.
   */
  public static String getAccessMode(ClientProjectFile file) {
    if (file.isUnderConstruction()) {
      return LNG.get("PRJ_FILE_READ_ONLY") + " ("
        + LNG.get("PRJ_UNDER_CONSTRUCTION_FILE") + ")";
    }
    if (!file.isDirectory()) {
      return LNG.get("PRJ_FILE_READ_AND_WRITE");
    }
    return " ";
  }
}
