/*
 * Decompiled with CFR 0.152.
 */
package csbase.client;

import csbase.client.Client;
import csbase.exception.CSBaseException;
import csbase.logic.LoginInfo;
import csbase.logic.MonitoredServer;
import csbase.logic.ServerManager;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.remote.ServerEntryPoint;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;

public final class ClientServerManager
extends ServerManager {
    private static ClientServerManager instance = null;
    Set<String> serviceNames;

    public ClientServerManager() {
        this(true);
    }

    public ClientServerManager(boolean sharedServerData) {
        super(sharedServerData);
    }

    public static int getWindowSize() {
        try {
            Configuration conf = ConfigurationManager.getInstance().getConfiguration(Client.class);
            return Integer.parseInt(conf.getOptionalProperty("monitor.server.window"));
        }
        catch (Throwable e) {
            System.out.println("O valor da propriedade monitor.server.window n\u00e3o foi encontrado. Usando o valor default: 5");
            return 5;
        }
    }

    private Session doLoginWithReference(ServerURI serverURI, String delegatedLogin, Locale locale, TimeZone timeZone, boolean copyServerSessionAttrs) throws CSBaseException, RemoteException {
        ServerURI defaultServerURI = this.getDefaultURI();
        ServerEntryPoint server = this.getServer(serverURI);
        Session session = this.getSession(defaultServerURI);
        return server.login(defaultServerURI, serverURI.getParamsMap(), copyServerSessionAttrs, session.getKey(), session.getUser().getLogin(), delegatedLogin, locale, timeZone);
    }

    private Session doLoginWithUserAndPassword(ServerURI serverURI, String loginName, String password, String delegatedLogin, Locale locale, TimeZone timeZone) throws RemoteException {
        ServerEntryPoint server = this.getServer(serverURI);
        TimeZone tz = timeZone;
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        return server.login(loginName, password, locale, tz, delegatedLogin, serverURI.getParamsMap());
    }

    public final boolean loginByReference(ServerURI serverURI, String delegatedLogin, boolean copyServerSessionAttrs, boolean ignoreVersion) throws CSBaseException, RemoteException {
        return this.loginByReference(serverURI, delegatedLogin, null, copyServerSessionAttrs, ignoreVersion);
    }

    public final boolean loginByReference(ServerURI serverURI, String delegatedLogin, TimeZone timeZone, boolean copyServerSessionAttrs, boolean ignoreVersion) throws CSBaseException, RemoteException {
        return this.loginByReference(serverURI, delegatedLogin, null, timeZone, copyServerSessionAttrs, ignoreVersion);
    }

    public final boolean loginByReference(ServerURI serverURI, String delegatedLogin, Locale locale, TimeZone timeZone, boolean copyServerSessionAttrs, boolean ignoreVersion) throws CSBaseException, RemoteException {
        ReferedMonitoredServer monitoredServer = this.serviceNames == null ? new ReferedMonitoredServer(serverURI, copyServerSessionAttrs) : new ReferedMonitoredServer(serverURI, copyServerSessionAttrs, this.serviceNames);
        monitoredServer.setDelegatedLogin(delegatedLogin);
        monitoredServer.setTimeZone(timeZone);
        monitoredServer.setLocale(locale);
        this.addServer(monitoredServer);
        return this.doLogin(serverURI);
    }

    public final boolean loginByReference(ServerURI serverURI, boolean copyServerSessionAttrs) throws CSBaseException, RemoteException {
        return this.loginByReference(serverURI, null, copyServerSessionAttrs, false);
    }

    public final boolean loginByReference(ServerURI serverURI, String delegatedLogin, boolean copyServerSessionAttrs) throws CSBaseException, RemoteException {
        return this.loginByReference(serverURI, delegatedLogin, copyServerSessionAttrs, false);
    }

    public final boolean loginWithUserPassword(ServerURI serverURI, LoginInfo loginInfo, boolean ignoreVersion) throws CSBaseException, RemoteException {
        return this.loginWithUserPassword(serverURI, loginInfo, null, ignoreVersion);
    }

    public final boolean loginWithUserPassword(ServerURI serverURI, LoginInfo loginInfo, String delegatedLogin, boolean ignoreVersion) throws CSBaseException, RemoteException {
        return this.loginWithUserPassword(serverURI, loginInfo, null, delegatedLogin, ignoreVersion);
    }

    public final boolean loginWithUserPassword(ServerURI serverURI, LoginInfo loginInfo, TimeZone timeZone, String delegatedLogin, boolean ignoreVersion) throws CSBaseException, RemoteException {
        UserAndPasswordMonitoredServer monitoredServer = this.serviceNames == null ? new UserAndPasswordMonitoredServer(serverURI, loginInfo, ignoreVersion) : new UserAndPasswordMonitoredServer(serverURI, loginInfo, this.serviceNames, ignoreVersion);
        monitoredServer.setDelegatedLogin(delegatedLogin);
        monitoredServer.setTimeZone(timeZone);
        this.addServer(monitoredServer);
        return this.doLogin(serverURI);
    }

    public final boolean loginWithUserPassword(ServerURI serverURI, LoginInfo loginInfo) throws CSBaseException, RemoteException {
        return this.loginWithUserPassword(serverURI, loginInfo, false);
    }

    public static ClientServerManager getInstance() {
        if (instance == null) {
            instance = new ClientServerManager();
        }
        return instance;
    }

    public final void setServiceNames(Set<String> serviceNames) {
        this.serviceNames = serviceNames;
    }

    private final class UserAndPasswordMonitoredServer
    extends MonitoredServer {
        LoginInfo loginInfo;

        protected UserAndPasswordMonitoredServer(ServerURI serverURI, LoginInfo loginInfo) {
            super(serverURI, Client.getInstance().getClientRemoteLocatorClass(), ClientServerManager.getWindowSize());
            this.loginInfo = null;
            this.loginInfo = loginInfo;
        }

        protected UserAndPasswordMonitoredServer(ServerURI serverURI, LoginInfo loginInfo, Set<String> serviceNames) {
            super(serverURI, serviceNames, ClientServerManager.getWindowSize());
            this.loginInfo = null;
            this.loginInfo = loginInfo;
        }

        protected UserAndPasswordMonitoredServer(ServerURI serverURI, LoginInfo loginInfo, boolean ignoreVersion) {
            super(serverURI, Client.getInstance().getClientRemoteLocatorClass(), ignoreVersion, ClientServerManager.getWindowSize());
            this.loginInfo = null;
            this.loginInfo = loginInfo;
        }

        protected UserAndPasswordMonitoredServer(ServerURI serverURI, LoginInfo loginInfo, Set<String> serviceNames, boolean ignoreVersion) {
            super(serverURI, serviceNames, ignoreVersion, ClientServerManager.getWindowSize());
            this.loginInfo = null;
            this.loginInfo = loginInfo;
        }

        public Session performLogin() throws CSBaseException, RemoteException {
            return ClientServerManager.this.doLoginWithUserAndPassword(this.getURI(), this.loginInfo.getLoginName(), this.loginInfo.getPassword(), this.delegatedLogin, this.loginInfo.getLocale(), this.timeZone);
        }

        public void postLogin() throws CSBaseException {
        }

        protected String lng(String key) {
            return LNG.get((String)key);
        }

        protected void setLoginInfo(LoginInfo loginInfo) {
            this.loginInfo = loginInfo;
        }
    }

    private final class ReferedMonitoredServer
    extends MonitoredServer {
        private boolean copyServerSessionAttrs;
        private Locale locale;

        protected ReferedMonitoredServer(ServerURI serverURI, boolean copyServerSessionAttrs) {
            super(serverURI, Client.getInstance().getClientRemoteLocatorClass(), ClientServerManager.getWindowSize());
            this.locale = Locale.getDefault();
            this.copyServerSessionAttrs = copyServerSessionAttrs;
        }

        protected ReferedMonitoredServer(ServerURI serverURI, boolean copyServerSessionAttrs, Set<String> serviceNames) {
            super(serverURI, serviceNames, ClientServerManager.getWindowSize());
            this.locale = Locale.getDefault();
            this.copyServerSessionAttrs = copyServerSessionAttrs;
        }

        protected ReferedMonitoredServer(ServerURI serverURI, boolean copyServerSessionAttrs, boolean ignoreVersion) {
            super(serverURI, Client.getInstance().getClientRemoteLocatorClass(), ignoreVersion, ClientServerManager.getWindowSize());
            this.locale = Locale.getDefault();
            this.copyServerSessionAttrs = copyServerSessionAttrs;
        }

        protected ReferedMonitoredServer(ServerURI serverURI, boolean copyServerSessionAttrs, Set<String> serviceNames, boolean ignoreVersion) {
            super(serverURI, serviceNames, ignoreVersion, ClientServerManager.getWindowSize());
            this.locale = Locale.getDefault();
            this.copyServerSessionAttrs = copyServerSessionAttrs;
        }

        public Session performLogin() throws CSBaseException, RemoteException {
            return ClientServerManager.this.doLoginWithReference(this.getURI(), this.delegatedLogin, this.locale, this.timeZone, this.copyServerSessionAttrs);
        }

        public void postLogin() throws CSBaseException {
        }

        protected String lng(String key) {
            return LNG.get((String)key);
        }

        protected void setLocale(Locale locale) {
            if (locale != null) {
                this.locale = locale;
            }
        }
    }
}

