/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.events.AbstractCommandUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.newview.AbstractTab;
import csbase.client.algorithms.commands.newview.CommandView;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.logic.CommandInfo;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StatusBar;

class CommandViewFrame
extends DesktopComponentFrame {
    private static final long MINIMUN_HEIGHT = 600L;
    private static final long MINIMUN_WIDTH = 800L;
    private CommandView commandView;
    private AbstractCommandUpdatedEventListener commandListener;

    public CommandViewFrame(CommandView commandView, Object index, DesktopComponentFrame owner, CommandInfo command) throws ClientException {
        super(index, owner, "");
        if (command == null) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        if (commandView == null) {
            throw new IllegalArgumentException("O par\u00e2metro commandView est\u00e1 nulo.");
        }
        this.commandView = commandView;
        this.initializeGui();
        this.createListeners(command);
    }

    @Override
    public void pack() {
        super.pack();
        this.updateSize();
        if (this.owner != null) {
            this.setLocationRelativeTo(this.owner);
        }
    }

    private void initializeGui() throws ClientException {
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.add(this.commandView.getMainComponent(this), "Center");
        this.setTitle(this.commandView.getTitle());
        this.pack();
    }

    private void updateSize() {
        double factor = 0.85;
        int offset = 35;
        Dimension screenSize = GUIUtils.getScreenDimension();
        Dimension currentSize = this.getSize();
        double currentWidth = currentSize.getWidth() * 0.85;
        double newWidth = Math.max(currentWidth, 800.0);
        double usuableWidth = screenSize.getWidth();
        newWidth = Math.min(newWidth, usuableWidth);
        double currentHeight = currentSize.getHeight() * 0.85;
        double newHeight = Math.max(currentHeight, 600.0);
        double usuableHeight = screenSize.getHeight();
        newHeight = Math.min(newHeight, usuableHeight);
        Dimension newSize = new Dimension();
        newSize.setSize(newWidth + 35.0, newHeight + 35.0);
        this.setSize(newSize);
    }

    private void createListeners(CommandInfo command) {
        this.commandListener = new AbstractCommandUpdatedEventListener(command.getProjectId(), command.getId()){

            @Override
            public void eventFired(CommandUpdatedEvent.Type type, CommandInfo newCmdInfo) {
                CommandViewFrame.this.commandView.commandUpdated(type, newCmdInfo);
            }

            @Override
            protected void eventInterrupted(Exception exception, String description) {
                StatusBar statusBar = CommandViewFrame.this.commandView.getStatusBar();
                statusBar.setError(description);
            }
        };
        CommandsCache.getInstance().addEventListener(this.commandListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CommandsCache.getInstance().removeEventListener(CommandViewFrame.this.commandListener);
                CommandViewFrame.this.commandView.close();
                CommandViewFrame.removeDesktopComponentFrame(CommandViewFrame.this.getIndex());
            }
        });
    }

    public void showTab(AbstractTab.TabType tabType) throws ClientException {
        this.commandView.selectTab(tabType);
        this.setVisible(true);
    }

    public void showTab(String title) throws ClientException {
        this.commandView.selectTab(title);
        this.setVisible(true);
    }
}

