/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.newview.AbstractTab;
import csbase.client.algorithms.commands.newview.CommandView;
import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.ErrorView;
import csbase.client.algorithms.commands.newview.FlowDetailsView;
import csbase.client.algorithms.commands.newview.NodeCommandView;
import csbase.client.algorithms.commands.newview.Tab;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.configurator.FlowAlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.PopupFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.GraphNodeImageDecoration;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.graph.actions.GraphElementAction;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.ProgressData;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JSplitPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StatusBar;
import tecgraf.vix.TypeVO;

class FlowCommandView
implements CommandView {
    protected CommandInfo command;
    protected FlowAlgorithmConfigurator configurator;
    protected JSplitPane mainComponent;
    protected FlowAlgorithmConfiguratorView configuratorView;
    protected CommandView selectedView;
    protected CommandView detailsView;
    protected Map<Integer, NodeCommandView> nodeViewCache;
    protected DesktopComponentFrame owner;
    private GraphNode selectedNode;

    public FlowCommandView(CommandInfo cmd, FlowAlgorithmConfigurator configurator) throws ClientException {
        if (cmd == null) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        this.nodeViewCache = new HashMap<Integer, NodeCommandView>();
        this.command = cmd;
        this.configurator = configurator;
    }

    @Override
    public void commandUpdated(CommandUpdatedEvent.Type type, CommandInfo newCmdInfo) {
        this.command = newCmdInfo;
        this.detailsView.commandUpdated(type, newCmdInfo);
        for (NodeCommandView nodeView : this.nodeViewCache.values()) {
            nodeView.commandUpdated(type, newCmdInfo);
        }
        try {
            this.addCommandStatusDecoration(this.configuratorView.getGraph());
        }
        catch (ClientException e) {
            StatusBar statusBar = this.selectedView.getStatusBar();
            statusBar.setError(e.getMessage());
        }
    }

    private void addCommandStatusDecoration(Graph graph) throws ClientException {
        if (this.command != null) {
            if (this.command.getStatus() == CommandStatus.FINISHED) {
                this.addFinishedCommandStatusDecoration(graph);
            } else {
                this.addRunningCommandStatusDecoration(graph);
            }
        } else {
            String message = LNG.get((String)(FlowCommandView.class.getSimpleName() + ".error.command.not.found"));
            throw new ClientException(message);
        }
    }

    private void addRunningCommandStatusDecoration(Graph graph) {
        switch (this.command.getStatus()) {
            case SYSTEM_FAILURE: {
                this.addImageDecoration(graph, GraphNodeImageDecoration.DecorationType.SYSTEM_FAILURE);
                break;
            }
            case SCHEDULED: {
                this.addImageDecoration(graph, GraphNodeImageDecoration.DecorationType.SCHEDULED);
                break;
            }
            case EXECUTING: {
                if (this.command.getProgressData() != null) {
                    this.addProgressDecoration(graph, this.command.getProgressDataMap());
                    break;
                }
                this.addImageDecoration(graph, GraphNodeImageDecoration.DecorationType.EXECUTION);
                break;
            }
            case INIT: 
            case UPLOADING: 
            case DOWNLOADING: {
                this.addImageDecoration(graph, GraphNodeImageDecoration.DecorationType.EXECUTION);
                break;
            }
            default: {
                this.addImageDecoration(graph, GraphNodeImageDecoration.DecorationType.BLANK);
            }
        }
    }

    private void addImageDecoration(Graph graph, GraphNodeImageDecoration.DecorationType decoration) {
        for (GraphNode graphNode : graph.getNodeCollection()) {
            if (graphNode.isBypassed()) continue;
            graphNode.addImageDecoration(decoration);
        }
    }

    private void addProgressDecoration(Graph graph, Map<Integer, ProgressData> map) {
        String key = FlowCommandView.class.getSimpleName() + ".tooltip.progress.description";
        for (GraphNode graphNode : graph.getNodeCollection()) {
            ProgressData progressData;
            if (graphNode.isBypassed() || (progressData = map.get(graphNode.getId())) == null) continue;
            String description = LNG.get((String)key, (Object[])new Object[]{graphNode.getAlgorithmName(), progressData.getDescription()});
            String formattedValue = progressData.getFormattedValue();
            graphNode.addTextDecoration(formattedValue, description);
        }
    }

    private void addFinishedCommandStatusDecoration(Graph graph) {
        CommandFinalizationInfo info = this.command.getFinalizationInfo();
        if (info != null) {
            if (this.configurator.canBeRunAsSimpleCommand()) {
                GraphNode node = graph.getNodeCollection().iterator().next();
                this.decorateNode(node, info, false, false);
            } else if (info.getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
                ExtendedCommandFinalizationInfo finalizationInfo = (ExtendedCommandFinalizationInfo)info;
                for (GraphNode node : graph.getNodeCollection()) {
                    CommandFinalizationInfo nodeFinalizationInfo = finalizationInfo.getFinalizationInfoForNode(node.getId());
                    Integer guiltyNodeId = finalizationInfo.getGuiltyNodeId();
                    boolean commandWasInterrupted = false;
                    boolean isGuilty = false;
                    if (guiltyNodeId != null) {
                        commandWasInterrupted = true;
                        if (guiltyNodeId.intValue() == node.getId()) {
                            isGuilty = true;
                        }
                    }
                    this.decorateNode(node, nodeFinalizationInfo, commandWasInterrupted, isGuilty);
                }
            }
        }
    }

    private void decorateNode(GraphNode node, CommandFinalizationInfo finalizationInfo, boolean commandWasInterrupted, boolean isGuilty) {
        GraphNodeImageDecoration.DecorationType decoration = GraphNodeImageDecoration.DecorationType.BLANK;
        if (!node.isBypassed()) {
            if (commandWasInterrupted && isGuilty) {
                decoration = GraphNodeImageDecoration.DecorationType.FATAL_ERROR;
            } else {
                switch (finalizationInfo.getFinalizationType()) {
                    case EXECUTION_ERROR: {
                        if (commandWasInterrupted) {
                            decoration = GraphNodeImageDecoration.DecorationType.NON_FATAL_ERROR;
                            break;
                        }
                        decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_ERROR;
                        break;
                    }
                    case NO_EXIT_CODE: {
                        if (commandWasInterrupted) {
                            decoration = GraphNodeImageDecoration.DecorationType.INTERRUPTED;
                            break;
                        }
                        decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_UNKNOWN;
                        break;
                    }
                    case SUCCESS: {
                        decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_SUCCESS;
                        break;
                    }
                    default: {
                        decoration = GraphNodeImageDecoration.DecorationType.BLANK;
                    }
                }
            }
        }
        node.addImageDecoration(decoration);
    }

    private void createFilters(Workspace workspace) {
        new AddNodePopupActionFilter(workspace){

            @Override
            protected Action createAction(GraphNode graphNode, Point2D point) {
                if (graphNode != null && !graphNode.isBypassed()) {
                    return new ShowAlgorithmCommandViewPopupAction(graphNode);
                }
                return null;
            }
        }.attach();
        new PopupFilter(workspace).attach();
        new ShowAlgorithmDetailsClickAction(workspace).attach();
    }

    private void setSelectedView(CommandView view) throws ClientException {
        if (this.mainComponent == null) {
            this.mainComponent = new JSplitPane(1);
            this.mainComponent.setOneTouchExpandable(true);
            AlgorithmConfiguratorFactory configuratorFactory = AlgorithmConfiguratorFactory.getInstance();
            this.configuratorView = (FlowAlgorithmConfiguratorView)configuratorFactory.createReportView(this.owner, (AlgorithmConfigurator)this.configurator);
            this.createFilters(this.configuratorView.getWorkspace());
            this.addCommandStatusDecoration(this.configuratorView.getGraph());
            this.mainComponent.setLeftComponent(this.configuratorView.getMainComponent());
        }
        String title = null;
        AbstractTab.TabType type = null;
        Integer dividerLocation = null;
        if (this.selectedView != null) {
            Tab selected = this.selectedView.getSelected();
            if (selected != null) {
                selected.setSelected(false);
                title = selected.getTitle();
                type = selected.getType();
            }
            dividerLocation = this.mainComponent.getDividerLocation();
        }
        this.selectedView = view;
        this.owner.setTitle(this.getTitle());
        Component selectedComponent = this.selectedView.getMainComponent(this.owner);
        if (title != null) {
            this.selectedView.selectTab(title);
        } else if (type != null) {
            this.selectedView.selectTab(type);
        } else {
            this.selectedView.selectPreferredTab();
        }
        this.mainComponent.setRightComponent(selectedComponent);
        if (dividerLocation != null) {
            this.mainComponent.setDividerLocation(dividerLocation);
        }
    }

    @Override
    public Component getMainComponent(DesktopComponentFrame window) throws ClientException {
        if (this.mainComponent == null) {
            this.owner = window;
            this.detailsView = new FlowDetailsView(this.command, this.configurator);
            this.setSelectedView(this.detailsView);
        }
        return this.mainComponent;
    }

    @Override
    public String getTitle() {
        if (this.selectedNode != null) {
            return LNG.get((String)(FlowCommandView.class.getSimpleName() + ".window.title.node"), (Object[])new Object[]{this.command.getId(), this.selectedNode.getAlgorithmName(), this.selectedNode.getAlgorithmVersionId()});
        }
        return LNG.get((String)(FlowCommandView.class.getSimpleName() + ".window.title"), (Object[])new Object[]{this.command.getId()});
    }

    @Override
    public void selectTab(AbstractTab.TabType tabType) throws ClientException {
        this.selectedView.selectTab(tabType);
    }

    @Override
    public void selectTab(String title) throws ClientException {
        this.selectedView.selectTab(title);
    }

    @Override
    public Tab getSelected() {
        return this.selectedView.getSelected();
    }

    @Override
    public StatusBar getStatusBar() {
        return this.selectedView.getStatusBar();
    }

    @Override
    public void selectPreferredTab() throws ClientException {
        this.selectedView.selectPreferredTab();
    }

    @Override
    public void close() {
        this.detailsView.close();
        for (NodeCommandView nodeView : this.nodeViewCache.values()) {
            nodeView.close();
        }
    }

    private final class ShowAlgorithmCommandViewPopupAction
    extends GraphElementAction {
        public ShowAlgorithmCommandViewPopupAction(GraphNode node) {
            super(node, FlowCommandView.class.getSimpleName() + ".action.show.node", ApplicationImages.ICON_INFORMATION_16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphNode node = (GraphNode)this.getElement();
            if (node != null && !node.isBypassed()) {
                try {
                    Tab selected = FlowCommandView.this.selectedView.getSelected();
                    AbstractTab.TabType type = selected != null ? selected.getType() : AbstractTab.TabType.STATIC;
                    CommandViewFactory.showNodeView(FlowCommandView.this.command, FlowCommandView.this.owner, type, node);
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog((Window)FlowCommandView.this.owner, FlowCommandView.this.getTitle(), (Throwable)ex);
                }
            }
        }
    }

    private class ShowAlgorithmDetailsClickAction
    extends WorkspaceFilter {
        public ShowAlgorithmDetailsClickAction(Workspace workspace) {
            super(workspace);
        }

        public void callbackButton(Point2D pt, MouseEvent ev) {
            if (ev.getButton() == 1 && ev.getID() == 500) {
                PickNodeMessage pickNodeMessage = new PickNodeMessage(pt);
                pickNodeMessage.sendVO((TypeVO)this);
                GraphNode node = pickNodeMessage.getNode();
                if (node == FlowCommandView.this.selectedNode || node != null && node.isBypassed()) {
                    return;
                }
                try {
                    if (FlowCommandView.this.selectedNode != null) {
                        FlowCommandView.this.selectedNode.setSelected(false);
                        FlowCommandView.this.selectedNode.repaint();
                    }
                    FlowCommandView.this.selectedNode = node;
                    if (node != null) {
                        NodeCommandView view = FlowCommandView.this.nodeViewCache.get(node.getId());
                        if (view == null) {
                            AlgorithmConfiguratorView algorithmConfiguratorView = node.getAlgorithmConfiguratorView();
                            if (algorithmConfiguratorView != null) {
                                view = new NodeCommandView(node.getId(), FlowCommandView.this.command, algorithmConfiguratorView.getConfigurator());
                                FlowCommandView.this.nodeViewCache.put(node.getId(), view);
                            } else {
                                this.showErrorView(node);
                            }
                        }
                        if (view != null) {
                            node.setSelected(true);
                            FlowCommandView.this.selectedNode.repaint();
                            FlowCommandView.this.setSelectedView(view);
                        }
                    } else {
                        FlowCommandView.this.setSelectedView(FlowCommandView.this.detailsView);
                    }
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog((Window)FlowCommandView.this.owner, FlowCommandView.this.getTitle(), (Throwable)ex);
                }
            }
            super.callbackButton(pt, ev);
        }

        private void showErrorView(GraphNode node) throws ClientException {
            String errorMessage = LNG.get((String)(FlowCommandView.class.getSimpleName() + ".error.loading.view"), (Object[])new Object[]{node.getAlgorithmName()});
            ErrorView errorView = new ErrorView(errorMessage);
            FlowCommandView.this.setSelectedView(errorView);
        }
    }
}

