/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandviewer;

import csbase.client.algorithms.commands.CommandViewerPanel;
import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.executor.ExecutorFrame;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.desktop.RemoteTask;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.CommandInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;

public final class CommandViewerApplication
extends ApplicationProject {
    private CommandViewerPanel panel;

    public CommandViewerApplication(String id) {
        super(id);
        this.createGui();
    }

    @Override
    public void killApplication() {
        this.panel.stop();
    }

    @Override
    public void startApplication() throws ApplicationException {
        super.startApplication();
        this.panel.start();
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    private JMenu createCommandMenu() {
        JMenu commandMenu = new JMenu(this.getMessage("label_command_menu"));
        JMenuItem openCommandMenuItem = new JMenuItem(this.panel.getShowCommandAction());
        commandMenu.add(openCommandMenuItem);
        JMenuItem openCommandLogMenuItem = new JMenuItem(this.panel.getShowCommandLogAction());
        commandMenu.add(openCommandLogMenuItem);
        JMenuItem exportCommandMenuItem = new JMenuItem(this.panel.getExportCommandAction());
        commandMenu.add(exportCommandMenuItem);
        JMenuItem removeCommandMenuItem = new JMenuItem(this.panel.getRemoveCommandAction());
        commandMenu.add(removeCommandMenuItem);
        JMenuItem killCommandMenuItem = new JMenuItem(this.panel.getKillCommandAction());
        commandMenu.add(killCommandMenuItem);
        if (this.hasAdvancedMenu()) {
            commandMenu.addSeparator();
            JMenu advancedSubMenu = this.createAdvancedMenu();
            commandMenu.add(advancedSubMenu);
        }
        commandMenu.addSeparator();
        commandMenu.add(new ApplicationExitAction(this));
        return commandMenu;
    }

    private boolean hasAdvancedMenu() {
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        if (cnfManager == null) {
            return false;
        }
        try {
            Class<CommandViewerApplication> propClass = CommandViewerApplication.class;
            Configuration cnf = cnfManager.getConfiguration(propClass);
            String propName = "enable.advanced.menu";
            return cnf.getOptionalBooleanProperty("enable.advanced.menu", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    private JMenu createAdvancedMenu() {
        JMenu advancedSubMenu = new JMenu(this.getMessage("label_advanced_menu"));
        advancedSubMenu.add(this.createRefreshCommandsAction());
        return advancedSubMenu;
    }

    private JMenuItem createRefreshCommandsAction() {
        JMenuItem refreshMenuItem = new JMenuItem(this.getMessage("label_refresh_menu_item"));
        refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RemoteTask<Void> task = new RemoteTask<Void>(){

                    public void performTask() throws Exception {
                        CommandsCache.getInstance().hardReload(CommandViewerApplication.this.getApplicationProject().getId());
                    }
                };
                String msg = CommandViewerApplication.this.getMessage("message_refreshing");
                if (!task.execute(CommandViewerApplication.this.getApplicationFrame(), msg, msg) && task.getError() != null) {
                    CommandViewerApplication.this.showExceptionStack(task.getError());
                }
            }
        });
        return refreshMenuItem;
    }

    private void createGui() {
        this.buildApplicationFrame();
        ApplicationFrame applicationFrame = this.getApplicationFrame();
        this.panel = new CommandViewerPanel(this.getApplicationFrame(), this.getApplicationProject().getId()){

            @Override
            protected boolean exportCommand(final CommandInfo command) {
                try {
                    RemoteTask<AlgorithmConfigurator> task = new RemoteTask<AlgorithmConfigurator>(){

                        public void performTask() throws Exception {
                            AlgorithmConfigurator configurator = command.getConfigurator();
                            this.setResult(configurator);
                        }
                    };
                    String msg = CommandViewerApplication.this.getMessage("loading_configurator");
                    if (!task.execute(CommandViewerApplication.this.getApplicationFrame(), msg, msg)) {
                        return false;
                    }
                    AlgorithmConfigurator configurator = (AlgorithmConfigurator)task.getResult();
                    if (null == configurator) {
                        CommandViewerApplication.this.showError(CommandViewerApplication.this.getMessage("error_loading_configurator"));
                        return false;
                    }
                    if (null == configurator.getAlgorithmName() && null == configurator.getAlgorithmVersionId() && configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                        ApplicationManager applicationManager = ApplicationManager.getInstance();
                        FlowApplication application = applicationManager.runApplication(FlowApplication.class);
                        return application.editConfigurator((FlowAlgorithmConfigurator)configurator, command.getDescription());
                    }
                    try {
                        String algName = configurator.getAlgorithmName();
                        AlgorithmVersionId algVersionId = configurator.getAlgorithmVersionId();
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        Set names = configurator.getParameterNames();
                        for (String name : names) {
                            String value = configurator.getParameterValue(name);
                            parameters.put(name, value);
                        }
                        ExecutorFrame executorFrame = (ExecutorFrame)ApplicationManager.getInstance().runApplication("executor");
                        executorFrame.showConfigurator(algName, algVersionId, parameters);
                        return true;
                    }
                    catch (ParameterNotFoundException e) {
                        CommandViewerApplication.this.showExceptionStack(e);
                        return false;
                    }
                }
                catch (ApplicationException e) {
                    CommandViewerApplication.this.showExceptionStack(e);
                    return false;
                }
            }
        };
        applicationFrame.add(this.panel);
        JMenuBar menuBar = this.createMenuBar();
        applicationFrame.setJMenuBar(menuBar);
        applicationFrame.pack();
        applicationFrame.pack();
        applicationFrame.setTitle(this.getMessage("title"));
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createCommandMenu());
        return menuBar;
    }

    private String getMessage(String keySuffix) {
        return LNG.get((String)(this.getClass().getSimpleName() + "." + keySuffix));
    }
}

