/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.zoom;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.zoom.ZoomListener;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import csbase.client.applications.flowapplication.zoom.ZoomSliderModel;
import csbase.client.applications.flowapplication.zoom.ZoomSpinnerModel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public final class ZoomControl
extends JToolBar {
    private ZoomModel model;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private ZoomFitAction zoomFitAction;

    public ZoomControl(ZoomModel model) {
        this.setLayout(new FlowLayout(2));
        this.setFloatable(false);
        this.setModel(model);
        this.buildZoomInAction();
        this.buildZoomOutAction();
        this.buildZoomFitAction();
        this.buildSlider();
        this.buildSpinner();
    }

    public Action getZoomInAction() {
        return this.zoomInAction;
    }

    public Action getZoomFitAction() {
        return this.zoomFitAction;
    }

    public Action getZoomOutAction() {
        return this.zoomOutAction;
    }

    private void buildSlider() {
        ZoomSliderModel sliderModel = new ZoomSliderModel(this.model);
        JSlider slider = new JSlider(sliderModel);
        slider.setMajorTickSpacing(sliderModel.getMajorTicks());
        slider.setMinorTickSpacing(sliderModel.getMinorTicks());
        slider.setOrientation(0);
        slider.setPaintTicks(true);
        this.add(slider);
    }

    private void buildSpinner() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("%"));
        panel.add(new JSpinner(new ZoomSpinnerModel(this.model)));
        this.add(panel);
    }

    private void buildZoomInAction() {
        this.zoomInAction = new ZoomInAction();
        JButton zoomInButton = new JButton(this.zoomInAction);
        zoomInButton.setText("");
        zoomInButton.setToolTipText(this.zoomInAction.getToolTipText());
        this.add(zoomInButton);
    }

    private void buildZoomFitAction() {
        this.zoomFitAction = new ZoomFitAction();
        JButton zoomFitButton = new JButton(this.zoomFitAction);
        zoomFitButton.setText("");
        zoomFitButton.setToolTipText(this.zoomFitAction.getToolTipText());
        this.add(zoomFitButton);
    }

    private void buildZoomOutAction() {
        this.zoomOutAction = new ZoomOutAction();
        JButton zoomOutButton = new JButton(this.zoomOutAction);
        zoomOutButton.setText("");
        zoomOutButton.setToolTipText(this.zoomOutAction.getToolTipText());
        this.add(zoomOutButton);
    }

    private void setModel(ZoomModel zoomModel) {
        this.model = zoomModel;
        this.model.addListener(new ZoomControlListener());
    }

    private void zoomIn() {
        this.model.setValue(this.model.getNextBlockValue());
    }

    private void zoomOut() {
        this.model.setValue(this.model.getPreviousBlockValue());
    }

    private void zoomFit() {
        this.model.setValue(this.model.getFitValue());
    }

    private final class ZoomFitAction
    extends Action {
        ZoomFitAction() {
            super("csbase.client.applications.flowapplication.zoom.ZoomControl.zoomFit", ApplicationImages.ICON_ZOOM_16, KeyStroke.getKeyStroke(36, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ZoomControl.this.zoomFit();
        }
    }

    private final class ZoomOutAction
    extends Action {
        ZoomOutAction() {
            super("csbase.client.applications.flowapplication.zoom.ZoomControl.zoomOut", ApplicationImages.ICON_ZOOMOUT_16, KeyStroke.getKeyStroke(109, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ZoomControl.this.zoomOut();
        }
    }

    private final class ZoomInAction
    extends Action {
        ZoomInAction() {
            super("csbase.client.applications.flowapplication.zoom.ZoomControl.zoomIn", ApplicationImages.ICON_ZOOMIN_16, KeyStroke.getKeyStroke(107, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ZoomControl.this.zoomIn();
        }
    }

    private final class ZoomControlListener
    implements ZoomListener {
        private ZoomControlListener() {
        }

        @Override
        public void wasChanged(ZoomModel zoomModel) {
            ZoomControl.this.zoomInAction.setEnabled(zoomModel.hasNextBlockValue());
            ZoomControl.this.zoomOutAction.setEnabled(zoomModel.hasPreviousBlockValue());
            double value = zoomModel.getValue();
            double defaultValue = zoomModel.getStandardValue();
            ZoomControl.this.zoomFitAction.setEnabled(value != defaultValue);
        }
    }
}

