/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.actions.io;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class ImageViewerOpenAction
extends ImageViewerAction {
    @Override
    protected ImageIcon getDefaultIcon() {
        return ApplicationImages.ICON_OPEN_16;
    }

    public ImageViewerOpenAction(ImageViewer application) {
        super(application);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) {
        ClientProjectFileChooserUtil.OperationResult result;
        ImageViewer application = (ImageViewer)this.getApplication();
        List<String> fileCodes = application.getFileTypes();
        if (fileCodes == null) {
            fileCodes = new ArrayList<String>();
        }
        if ((result = ClientProjectFileChooserUtil.browseSingleFileInOpenMode((Application)application, fileCodes, true)) == null) {
            return;
        }
        ClientProjectFile newFile = result.getClientProjectFile();
        boolean opened = application.openFile(newFile);
        if (!opened) {
            if (newFile.size() == 0L) {
                String msg = this.getString("ImageViewerOpenAction.zero.size.tip", new Object[0]);
                application.showInformation(msg);
            }
            return;
        }
        application.setCurrentFile((ClientFile)newFile);
    }
}

