/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.openbus;

import csbase.client.Client;
import csbase.client.login.LoginInterface;
import csbase.client.login.PreLogin;
import csbase.client.login.UserPasswordLogin;
import csbase.client.openbus.OnInvalidLogin;
import csbase.client.openbus.OpenBusEventSink;
import csbase.client.openbus.OpenBusLogin;
import csbase.client.openbus.OpenBusSession;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;
import csbase.exception.OperationFailureException;
import csbase.logic.BusInfo;
import csbase.logic.Session;
import csbase.logic.User;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.Authenticator;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenBusServiceInterface;
import csbase.remote.UserPasswordAuthenticator;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import scs.core.IComponent;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.SharedAuthSecret;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.exception.AlreadyLoggedIn;
import tecgraf.openbus.exception.InvalidEncodedStream;
import tecgraf.openbus.exception.InvalidLoginProcess;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.session_service.v1_05.SessionEventSinkPOA;

public final class OpenBusAccessPoint {
    private static final String OPENBUS_OFFER_ID_KEY = "openbus.offer.id";
    private static OpenBusAccessPoint instance;
    private volatile Boolean inited = false;
    private ORBThread orbThread;
    private final Configuration configuration;
    private String host;
    private int port;
    private Properties orbProperties;
    private OpenBusSession session;
    private OpenBusContext context;
    private Properties connectionProps;
    private Connection connection;

    private OpenBusAccessPoint() {
        this.setInited(false);
        try {
            ConfigurationManager configurationManager = ConfigurationManager.getInstance();
            this.configuration = configurationManager.getConfiguration(this.getClass());
        }
        catch (ConfigurationManagerException e) {
            throw new IllegalStateException(e);
        }
        PrivilegedAction<java.lang.Object> action = new PrivilegedAction<java.lang.Object>(){

            @Override
            public java.lang.Object run() {
                System.setSecurityManager(null);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    public static void destroy() {
        if (instance == null) {
            return;
        }
        instance.shutdown();
    }

    public static OpenBusAccessPoint getInstance() {
        if (instance == null) {
            instance = new OpenBusAccessPoint();
        }
        return instance;
    }

    public void init() throws CSBaseException, RemoteException {
        OpenBusServiceInterface openBusService = ClientRemoteLocator.openBusService;
        if (openBusService == null) {
            String err = this.getString("openbus.service.null.error");
            throw new CSBaseException(err);
        }
        if (!openBusService.isActive()) {
            String err = this.getString("openbus.service.inactive.error");
            throw new CSBaseException(err);
        }
        BusInfo busInfo = openBusService.getBusInfo();
        this.host = busInfo.getHost();
        this.port = busInfo.getPort();
        this.orbProperties = new Properties();
        this.orbProperties.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        Logger SDKLogger = Logger.getLogger("tecgraf.openbus");
        SDKLogger.setLevel(Level.WARNING);
        this.orbThread = new ORBThread(ORBInitializer.initORB(null, (Properties)this.orbProperties));
        this.orbThread.start();
        try {
            this.context = (OpenBusContext)this.orbThread.orb.resolve_initial_references("OpenBusContext");
        }
        catch (InvalidName e) {
            throw new CSBaseException("Falha ao obter o OpenBusContext.", (Throwable)e);
        }
        this.connectionProps = new Properties();
        this.connectionProps.put("legacy.disable", "false");
        this.connectionProps.put("legacy.delegate", "originator");
        try {
            this.connection = this.context.createConnection(this.host, this.port, this.connectionProps);
        }
        catch (InvalidPropertyValue e) {
            throw new CSBaseException("Falha ao criar a conex\u00e3o com o barramento.", (Throwable)e);
        }
        this.context.setDefaultConnection(this.connection);
        this.connection.onInvalidLoginCallback((InvalidLoginCallback)new OnInvalidLogin());
        this.connect();
        this.setInited(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInited(boolean flag) {
        Boolean bl = this.inited;
        synchronized (bl) {
            this.inited = flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInited() {
        Boolean bl = this.inited;
        synchronized (bl) {
            return this.inited;
        }
    }

    void connect() throws RemoteException, CSBaseException {
        Client client = Client.getInstance();
        LoginInterface loginObject = client.getLoginObject();
        if (loginObject instanceof OpenBusLogin) {
            ClientRemoteMonitor clientRemoteMonitor = ClientRemoteMonitor.getInstance();
            Session session = clientRemoteMonitor.getSession();
            OpenBusLoginToken token = (OpenBusLoginToken)session.getAttribute("CLIENT_TOKEN");
            this.connectWithToken(token);
        } else if (loginObject instanceof UserPasswordLogin) {
            User loggedUser = User.getLoggedUser();
            if (!loggedUser.getId().equals(User.getAdminId())) {
                this.connectForUser(loggedUser);
            }
        } else {
            if (loginObject instanceof PreLogin) {
                String err = "N\u00e3o \u00e9 poss\u00edvel fazer a conex\u00e3o com o barramento usando pre-login.";
                throw new CSBaseException("N\u00e3o \u00e9 poss\u00edvel fazer a conex\u00e3o com o barramento usando pre-login.");
            }
            String err = "N\u00e3o foi poss\u00edvel fazer a conex\u00e3o com o barramento (forma de logindescohecida).";
            throw new CSBaseException("N\u00e3o foi poss\u00edvel fazer a conex\u00e3o com o barramento (forma de logindescohecida).");
        }
    }

    private void connectWithToken(OpenBusLoginToken token) throws CSBaseException {
        try {
            SharedAuthSecret secret = this.getOpenBusContext().decodeSharedAuth(token.secret);
            this.connection.loginBySharedAuth(secret);
        }
        catch (InvalidEncodedStream e) {
            throw new CSBaseException("Erro durante a autentica\u00e7\u00e3o no barramento usando toke: erro na decodifica\u00e7\u00e3o do segredo .", (Throwable)e);
        }
        catch (AlreadyLoggedIn e) {
        }
        catch (InvalidLoginProcess e) {
            throw new CSBaseException("Erro durante a autentica\u00e7\u00e3o no barramento usando toke: login inv\u00e1lido.", (Throwable)e);
        }
        catch (AccessDenied e) {
            throw new CSBaseException("Erro durante a autentica\u00e7\u00e3o no barramento usando toke: acesso negado.", (Throwable)e);
        }
        catch (ServiceFailure e) {
            throw new CSBaseException("Erro durante a autentica\u00e7\u00e3o no barramento usando toke: erro inesperado no barramento.", (Throwable)e);
        }
    }

    private void connectForUser(User loggedUser) throws CSBaseException {
        ClientRemoteMonitor clientRemoteMonitor = ClientRemoteMonitor.getInstance();
        Authenticator authenticator = clientRemoteMonitor.getAuthenticator();
        boolean isUserAuthenticator = authenticator instanceof UserPasswordAuthenticator;
        if (!isUserAuthenticator) {
            String key = "no.user.authenticator.error";
            String err = this.getString("no.user.authenticator.error");
            throw new CSBaseException(err);
        }
        String login = clientRemoteMonitor.getLogin();
        if (login == null) {
            String key = "login.error";
            String err = this.getString("login.error");
            throw new CSBaseException(err);
        }
        String password = clientRemoteMonitor.getPassword();
        if (password == null) {
            String key = "password.error";
            String err = this.getString("password.error");
            throw new CSBaseException(err);
        }
        this.connectWithPassword(login, password);
    }

    private void connectWithPassword(String user, String password) throws CSBaseException {
        try {
            this.connection.loginByPassword(user, password.getBytes());
        }
        catch (AccessDenied e) {
            throw new CSBaseException("Erro durante a autentica\u00e7\u00e3o no barramento usando toke: acesso negado.", (Throwable)e);
        }
        catch (AlreadyLoggedIn e) {
        }
        catch (ServiceFailure e) {
            throw new CSBaseException("Erro durante a autentica\u00e7\u00e3o no barramento usando toke: erro inesperado no barramento.", (Throwable)e);
        }
    }

    private String getString(String key) {
        String prefix = this.getClass().getSimpleName();
        return LNG.get((String)(prefix + "." + key));
    }

    private void shutdown() {
        try {
            this.connection.logout();
        }
        catch (ServiceFailure serviceFailure) {
            // empty catch block
        }
        this.setInited(false);
    }

    public OpenBusLoginToken getLoginToken() throws CSBaseException {
        SharedAuthSecret authSecret;
        String userName;
        block6: {
            if (!this.isInited()) {
                throw new CSBaseException("OpenBusAccessPoint n\u00e3o iniciado.");
            }
            userName = (String)User.getLoggedUser().getId();
            authSecret = null;
            try {
                authSecret = this.connection.startSharedAuth();
            }
            catch (ServiceFailure e) {
                throw new CSBaseException("Erro ao obter token de login no barramento: erro inesperado no barramento.", (Throwable)e);
            }
            catch (TRANSIENT e) {
                throw new CSBaseException(String.format("O barramento em %s:%s esta inacess\u00edvel no momento.", this.host, this.port), (Throwable)e);
            }
            catch (COMM_FAILURE e) {
                throw new CSBaseException("Falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento.", (Throwable)e);
            }
            catch (NO_PERMISSION e) {
                if (e.minor != 1112888319) break block6;
                throw new CSBaseException(String.format("N\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento.", userName), (Throwable)e);
            }
        }
        return new OpenBusLoginToken(userName, this.getOpenBusContext().encodeSharedAuth(authSecret));
    }

    public byte[] makeChain() throws RemoteException, CSBaseException {
        if (!this.isInited()) {
            throw new CSBaseException("OpenBusAccessPoint n\u00e3o iniciado.");
        }
        BusInfo busInfo = null;
        busInfo = ClientRemoteLocator.openBusService.getBusInfo();
        String serverLoginId = busInfo.getLoginId();
        OpenBusContext context = null;
        try {
            context = this.getOpenBusContext();
        }
        catch (OperationFailureException e) {
            throw new CSBaseException((Throwable)e);
        }
        CallerChain chain = null;
        try {
            chain = context.makeChainFor(serverLoginId);
        }
        catch (InvalidLogins e) {
            throw new CSBaseException((Throwable)e);
        }
        catch (ServiceFailure e) {
            throw new CSBaseException((Throwable)e);
        }
        return context.encodeChain(chain);
    }

    public IComponent findService(Properties properties) throws CSBaseException {
        ServiceOfferDesc[] services;
        ServiceProperty[] serviceProps = new ServiceProperty[properties.size()];
        int i = 0;
        for (String key : properties.stringPropertyNames()) {
            serviceProps[i] = new ServiceProperty(key, properties.getProperty(key));
            ++i;
        }
        try {
            services = this.context.getOfferRegistry().findServices(serviceProps);
        }
        catch (Exception e) {
            throw new CSBaseException("Falha ao buscar servi\u00e7os com as seguintes propriedades: \n" + properties.toString(), (Throwable)e);
        }
        for (int j = 0; j < services.length; ++j) {
            IComponent service = services[j].service_ref;
            String offerId = "";
            for (ServiceProperty prop : services[j].properties) {
                if (!prop.name.equals(OPENBUS_OFFER_ID_KEY)) continue;
                offerId = prop.value;
                break;
            }
            try {
                if (service._non_existent()) continue;
                return service;
            }
            catch (TRANSIENT e) {
                System.err.println("WARNING: Oferta de servi\u00e7o encontrada (" + offerId + ") mas servi\u00e7o est\u00e1 inalcan\u00e7\u00e1vel.");
                continue;
            }
            catch (COMM_FAILURE e) {
                System.err.println("WARNING: Oferta de servi\u00e7o encontrada (" + offerId + ") mas houve falha na comunica\u00e7\u00e3o com servi\u00e7o encontrado.");
                continue;
            }
            catch (Exception e) {
                System.err.println("WARNING: Oferta de servi\u00e7o encontrada (" + offerId + ") mas houve falha ao testar a comunica\u00e7\u00e3o.");
                e.printStackTrace();
            }
        }
        return null;
    }

    public void initSession() throws CSBaseException {
        Class sessionEventSinkClass = null;
        try {
            String propSinkName = "session.event.sink.class";
            sessionEventSinkClass = this.configuration.getOptionalClassProperty("session.event.sink.class");
        }
        catch (ClassNotFoundException e) {
            String key = "no.sink.class.error";
            String err = this.getString("no.sink.class.error");
            throw new CSBaseException(err);
        }
        if (sessionEventSinkClass == null) {
            this.initSession(OpenBusEventSink.class);
        } else {
            this.initSession(sessionEventSinkClass);
        }
    }

    public void initSession(Class<? extends SessionEventSinkPOA> sessionEventSinkClass) throws CSBaseException {
        this.session = new OpenBusSession(sessionEventSinkClass);
    }

    public OpenBusSession getSession() {
        return this.session;
    }

    public ORB getORB() {
        return this.orbThread.orb;
    }

    public POA getRootPOA() throws OperationFailureException {
        try {
            POA poa = POAHelper.narrow((Object)this.getORB().resolve_initial_references("RootPOA"));
            if (!poa.the_POAManager().get_state().equals(State.ACTIVE)) {
                poa.the_POAManager().activate();
            }
            return poa;
        }
        catch (InvalidName e) {
            String msg = "Erro ao obter o POA.";
            throw new OperationFailureException(msg);
        }
        catch (AdapterInactive e) {
            String msg = "Erro ao obter o POA.";
            throw new OperationFailureException(msg);
        }
    }

    private OpenBusContext getOpenBusContext() throws OperationFailureException {
        OpenBusContext context = null;
        try {
            context = (OpenBusContext)this.getORB().resolve_initial_references("OpenBusContext");
        }
        catch (InvalidName e) {
            throw new OperationFailureException("Erro ao obter o contexto da conex\u00e3o com o o barramento.");
        }
        return context;
    }

    private static class ORBThread
    extends Thread {
        private final ORB orb;

        ORBThread(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }
}

