/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel;

import csbase.client.Client;
import csbase.client.desktop.LocalTask;
import csbase.client.util.iostring.TextWriter;
import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.logic.ClientFile;
import java.awt.Window;
import java.nio.charset.Charset;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.parsers.csv.CsvParser;

public class CSVFileUtils {
    public static void writeCSVFile(Window owner, String[][] contents, ClientFile file) throws OperationFailureException {
        try {
            String content = CSVFileUtils.generateCSVFileContent(contents);
            Client client = Client.getInstance();
            Charset charset = client.getSystemDefaultCharset();
            TextWriter.writeAllWithTask(owner, file, content, charset);
        }
        catch (Exception e) {
            throw new OperationFailureException((Throwable)e);
        }
    }

    public static String generateCSVFileContent(String[][] contents) {
        StringBuilder content = new StringBuilder();
        String lineSeparator = "\n";
        String valueSeparator = ",";
        String quote = "\"";
        String[][] arr$ = contents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] values;
            for (String value : values = arr$[i$]) {
                if (value != null) {
                    content.append("\"");
                    content.append(value);
                    content.append("\"");
                }
                content.append(",");
            }
            content.append("\n");
        }
        return content.toString();
    }

    public static String[][] readCSVFile(Window owner, final ClientFile file) throws OperationFailureException {
        Client client = Client.getInstance();
        final String lngPrefix = CSVFileUtils.class.getName();
        final Charset charset = client.getSystemDefaultCharset();
        LocalTask<String[][]> task = new LocalTask<String[][]>(){

            protected void performTask() throws Exception {
                CsvParser parser = new CsvParser();
                String[][] lines = parser.parse(file.getInputStream(), charset);
                if (lines.length > 0) {
                    int numParams = lines[0].length;
                    for (int i = 1; i < lines.length; ++i) {
                        if (lines[i].length == numParams) continue;
                        throw new ParseException(LNG.get((String)(lngPrefix + ".read.task.invalidLine.error"), (Object[])new Object[]{i + 1, lines[i].length, numParams}));
                    }
                }
                this.setResult(lines);
            }
        };
        if (!task.execute(owner, LNG.get((String)(lngPrefix + ".read.task.title")), LNG.get((String)(lngPrefix + ".read.task.message")))) {
            throw new OperationFailureException((Throwable)task.getError());
        }
        return (String[][])task.getResult();
    }
}

