/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.algorithms.AlgorithmConfiguratorViewListener;
import csbase.client.algorithms.AlgorithmHelpAction;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.tasks.ViewValidationTask;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTreePath;
import csbase.client.util.ClientUtilities;
import csbase.exception.ParseException;
import csbase.logic.CommonClientProject;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmConfiguratorListener;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class AlgorithmConfiguratorView
implements ViewValidator {
    private static final int MINIMUM_WIDTH = 600;
    private static final int MINIMUM_HEIGHT = 100;
    private JButton cancelButton;
    private JButton closeButton;
    private AlgorithmConfigurator configurator;
    private JButton confirmButton;
    private ProjectTreePath currentPath;
    private DesktopComponentDialog dialog;
    private JButton helpButton;
    private final List<AlgorithmConfiguratorViewListener> listeners;
    private Window owner;
    private Map<Object, Object> previousValues;
    private JButton restoreButton;
    private ValidationMode defaultValidationMode;
    private ParameterView.Mode mode;

    protected AlgorithmConfiguratorView(Window owner, AlgorithmConfigurator configurator, ParameterView.Mode mode, ValidationMode defaultValidationMode) {
        if (mode == null) {
            throw new IllegalArgumentException("O par\u00e2metro mode est\u00e1 nulo.");
        }
        if (defaultValidationMode == null) {
            throw new IllegalArgumentException("O par\u00e2metro defaultValidationMode est\u00e1 nulo.");
        }
        this.mode = mode;
        this.defaultValidationMode = defaultValidationMode;
        this.listeners = new LinkedList<AlgorithmConfiguratorViewListener>();
        this.setConfigurator(configurator);
        this.setOwner(owner);
        this.createDialog();
        this.createButtons();
    }

    protected AlgorithmConfiguratorView(Window owner, AlgorithmConfigurator configurator, ParameterView.Mode mode) {
        this(owner, configurator, mode, ValidationMode.FULL);
    }

    public final void addAlgorithmConfiguratorViewListener(AlgorithmConfiguratorViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public final List<AlgorithmConfiguratorViewListener> getAlgorithmConfiguratorViewListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public AlgorithmConfigurator getConfigurator() {
        return this.configurator;
    }

    public final ProjectTreePath getCurrentPath() {
        return this.currentPath;
    }

    public final CommonClientProject getProject() {
        CommonClientProject currentProject = DesktopFrame.getInstance().getProject();
        return currentProject;
    }

    public final void launch() {
        this.previousValues = this.configurator.exportValues();
        this.populateDialog();
        this.dialog.center(this.owner);
        this.dialog.setVisible(true);
    }

    public void setCurrentPath(ProjectTreePath currentPath) {
        this.currentPath = currentPath;
    }

    public final boolean setEnabled(boolean isEnabled) {
        return this.configurator.setEnabled(isEnabled);
    }

    public String toString() {
        return this.getConfigurator().toString();
    }

    public final DesktopComponentDialog getDialog() {
        return this.dialog;
    }

    public abstract JComponent getMainComponent();

    protected final Window getOwner() {
        return this.owner;
    }

    protected final void repopulateDialog() {
        this.populateDialog();
        this.updateLocation();
    }

    private void cancel() {
        if (this.previousValues != null) {
            try {
                this.configurator.importValues(this.previousValues);
            }
            catch (ParseException e) {
                StandardDialogs.showErrorDialog((Component)this.getDialog(), (String)this.getString("title_wrong_parameters"), (String)e.getLocalizedMessage());
            }
        }
        this.close();
        for (AlgorithmConfiguratorViewListener listener : this.listeners) {
            listener.wasCancelled(this);
        }
    }

    private void close() {
        this.previousValues = null;
        this.dialog.close();
    }

    private void confirm() {
        ViewValidationResult validation = ViewValidationTask.runTask(this.getDialog(), this, this.defaultValidationMode, true);
        if (validation.isWellSucceded()) {
            this.close();
            for (AlgorithmConfiguratorViewListener listener : this.listeners) {
                listener.wasConfirmed(this);
            }
        }
    }

    private void addStrokeAction(KeyStroke keyStroke, AbstractAction action) {
        JRootPane component = this.dialog.getRootPane();
        int condition = 1;
        InputMap inputMap = component.getInputMap(condition);
        ActionMap actionMap = component.getActionMap();
        String actionMapKey = keyStroke.toString();
        inputMap.put(keyStroke, actionMapKey);
        actionMap.put(actionMapKey, action);
    }

    private void createButtons() {
        this.cancelButton = new JButton();
        AbstractAction cancelAction = new AbstractAction(this.getString("cancelButton")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmConfiguratorView.this.cancelButton.requestFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmConfiguratorView.this.cancel();
                    }
                });
            }
        };
        this.addStrokeAction(KeyStroke.getKeyStroke(27, 0), cancelAction);
        this.cancelButton.setAction(cancelAction);
        this.closeButton = new JButton(this.getString("closeButton"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmConfiguratorView.this.close();
            }
        });
        this.confirmButton = new JButton();
        AbstractAction enterAction = new AbstractAction(this.getString("confirmButton")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmConfiguratorView.this.confirmButton.requestFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmConfiguratorView.this.confirm();
                    }
                });
            }
        };
        this.addStrokeAction(KeyStroke.getKeyStroke(10, 64), enterAction);
        this.confirmButton.setAction(enterAction);
        AlgorithmVersionInfo algorithmVersionInfo = this.getConfigurator().getAlgorithmVersion();
        AlgorithmHelpAction algorithmHelpAction = this.getHelpAction(this.dialog, algorithmVersionInfo);
        algorithmHelpAction.hideIcon();
        this.helpButton = new JButton(algorithmHelpAction);
        this.addStrokeAction(KeyStroke.getKeyStroke(112, 0), algorithmHelpAction);
        this.restoreButton = new JButton(this.getString("resetDefaultValues"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmConfiguratorView.this.getConfigurator().resetValues();
            }
        });
    }

    private AlgorithmHelpAction getHelpAction(DesktopComponentDialog dialog, AlgorithmVersionInfo algorithmVersionInfo) {
        if (algorithmVersionInfo == null) {
            return new AlgorithmHelpAction(dialog);
        }
        return new AlgorithmHelpAction(dialog, algorithmVersionInfo);
    }

    private void createDialog() {
        this.dialog = new DesktopComponentDialog(this.owner);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (AlgorithmConfiguratorView.this.configurator.isEnabled()) {
                    AlgorithmConfiguratorView.this.cancel();
                } else {
                    AlgorithmConfiguratorView.this.close();
                }
            }
        });
        this.dialog.setModal(false);
    }

    private JPanel createOuterButtonPanel() {
        FlowLayout flowLayout = new FlowLayout();
        JPanel outerButtonPanel = new JPanel(flowLayout);
        if (this.configurator.isEnabled()) {
            flowLayout.setAlignment(1);
            ClientUtilities.adjustEqualSizes(this.cancelButton, this.confirmButton, this.helpButton);
            outerButtonPanel.add(this.confirmButton);
            outerButtonPanel.add(this.cancelButton);
            outerButtonPanel.add(this.helpButton);
        } else {
            flowLayout.setAlignment(1);
            outerButtonPanel.add(this.closeButton);
        }
        return outerButtonPanel;
    }

    private String getString(String key) {
        return LNG.get((String)(AlgorithmConfiguratorView.class.getName() + "." + key));
    }

    private String getString(String key, Object ... keyArgs) {
        return MessageFormat.format(this.getString(key), keyArgs);
    }

    private void populateDialog() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        int N = 10;
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JComponent mainComponent = this.getMainComponent();
        contentPanel.add((Component)mainComponent, "Center");
        JPanel outerButtonPanel = this.createOuterButtonPanel();
        contentPanel.add((Component)outerButtonPanel, "South");
        this.dialog.setContentPane(contentPanel);
        this.dialog.pack();
        this.updateSize();
        this.updateTitle();
    }

    private void setConfigurator(AlgorithmConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        this.configurator = configurator;
        this.configurator.addAlgorithmConfiguratorListener(new AlgorithmConfiguratorListener(){

            public void parameterLabelWasChanged(AlgorithmConfigurator cnf, String parameterName, String parameterLabel) {
            }

            public <V> void parameterValueWasChanged(AlgorithmConfigurator cnf, String parameterName, V parameterValue) {
            }

            public void parameterWasSetEnabled(AlgorithmConfigurator cnf, String parameterName, boolean parameterIsEnabled) {
            }

            public void parameterWasSetVisible(AlgorithmConfigurator cnf, String parameterName, boolean parameterIsVisible) {
                AlgorithmConfiguratorView.this.resizeOnVisibilityChanged();
            }

            public void wasSetEnabled(AlgorithmConfigurator cnf) {
                AlgorithmConfiguratorView.this.repopulateDialog();
            }
        });
    }

    private void setOwner(Window owner) {
        if (owner == null) {
            throw new IllegalArgumentException("O par\u00e2metro owner est\u00e1 nulo.");
        }
        this.owner = owner;
    }

    private void updateLocation() {
        double newUpperY;
        double newLeftmostX;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension currentSize = this.dialog.getSize();
        double usuableWidth = screenSize.getWidth();
        double currentWidth = currentSize.getWidth();
        double usuableHeight = screenSize.getHeight();
        double currentHeight = currentSize.getHeight();
        Point currentLocation = this.dialog.getLocation();
        double currentLeftmostX = currentLocation.getX();
        double availableWidth = usuableWidth - currentLeftmostX;
        double currentUpperY = currentLocation.getY();
        double availableHeight = usuableHeight - currentUpperY;
        if (availableWidth < currentWidth) {
            newLeftmostX = currentLeftmostX - (currentWidth - availableWidth);
            newLeftmostX = Math.max(newLeftmostX, 0.0);
        } else {
            newLeftmostX = currentLeftmostX;
        }
        if (availableHeight < currentHeight) {
            newUpperY = currentUpperY - (currentHeight - availableHeight);
            newUpperY = Math.max(newUpperY, 0.0);
        } else {
            newUpperY = currentUpperY;
        }
        Point newLocation = new Point();
        newLocation.setLocation(newLeftmostX, newUpperY);
        this.dialog.setLocation(newLocation);
    }

    public final void resizeOnVisibilityChanged() {
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        if (cnfManager == null) {
            return;
        }
        try {
            Class<AlgorithmConfiguratorView> propClass = AlgorithmConfiguratorView.class;
            Configuration cnf = cnfManager.getConfiguration(propClass);
            String propName = "resize.on.visibility.changed";
            if (cnf.getOptionalBooleanProperty("resize.on.visibility.changed", false).booleanValue()) {
                this.updateSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSize() {
        double factor = 0.85;
        int offset = 35;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension currentSize = this.dialog.getContentPane().getPreferredSize();
        double usuableWidth = screenSize.getWidth() * 0.85;
        double currentWidth = currentSize.getWidth();
        double newWidth = Math.min(currentWidth, usuableWidth);
        newWidth = Math.max(600.0, newWidth);
        double usuableHeight = screenSize.getHeight() * 0.85;
        double currentHeight = currentSize.getHeight();
        double newHeight = Math.min(currentHeight, usuableHeight);
        newHeight = Math.max(100.0, newHeight);
        Dimension newSize = new Dimension();
        newSize.setSize(newWidth + 35.0, newHeight + 35.0);
        this.dialog.setSize(newSize);
    }

    private void updateTitle() {
        String title = this.getString("title", this);
        this.dialog.setTitle(title);
    }

    public ParameterView.Mode getMode() {
        return this.mode;
    }
}

