/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.FileParameterView;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectDirectoryChooser;
import csbase.client.project.ProjectFileChooserSave;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.StandardDialogs;

public final class OutputFileParameterView
extends FileParameterView {
    @Deprecated
    public OutputFileParameterView(Window window, OutputFileParameter parameter) {
        this(parameter, ParameterView.Mode.CONFIGURATION);
    }

    public OutputFileParameterView(OutputFileParameter parameter, ParameterView.Mode mode) {
        super((FileParameter)parameter, mode);
    }

    @Override
    public OutputFileParameter getParameter() {
        return (OutputFileParameter)super.getParameter();
    }

    @Override
    protected FileURLValue askForFile() {
        try {
            if (FileParameterMode.REGULAR_FILE.equals((Object)this.getParameter().getMode())) {
                ProjectFileChooserSave chooser = new ProjectFileChooserSave(this.getWindow(), DesktopFrame.getInstance().getProject(), 0, this.getParameter().getFileType(), null, null, this.getParameter().usesFilter());
                ProjectTreePath projectTreePath = chooser.getSelectedPath();
                if (projectTreePath == null) {
                    return null;
                }
                ClientProjectFile clientProjectFile = projectTreePath.getFile();
                String type = clientProjectFile == null ? this.getParameter().getFileType() : (clientProjectFile.isDirectory() ? "DIRECTORY_TYPE" : clientProjectFile.getType());
                String path = FileUtils.joinPath((char)'/', (String[])projectTreePath.getPath());
                return new FileURLValue(path, type);
            }
            if (FileParameterMode.DIRECTORY.equals((Object)this.getParameter().getMode())) {
                ProjectDirectoryChooser chooser = new ProjectDirectoryChooser(DesktopFrame.getInstance().getProject(), this.getWindow());
                ProjectTreePath projectTreePath = chooser.getSelectedDirectory();
                if (projectTreePath == null) {
                    return null;
                }
                return new FileURLValue(FileUtils.joinPath((char)'/', (String[])projectTreePath.getPath()), "DIRECTORY_TYPE");
            }
            String errorMessage = MessageFormat.format("O modo de opera\u00e7\u00e3o {0} n\u00e3o \u00e9 suportado.", this.getParameter().getMode());
            throw new IllegalStateException(errorMessage);
        }
        catch (ClientException e) {
            String errorMessage = "Ocorreu um erro ao abrir o di\u00e1logo de sele\u00e7\u00e3o de arquivos.";
            if (e.getLocalizedMessage() != null) {
                errorMessage = errorMessage + "\nDetalhes:\n";
                errorMessage = errorMessage + e.getLocalizedMessage();
            }
            StandardDialogs.showErrorDialog((Component)this.getWindow(), (String)"Erro ao abrir o di\u00e1logo de sele\u00e7\u00e3o de arquivo", (String)errorMessage);
            return null;
        }
    }
}

