/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class ApplicationClassLoader
extends URLClassLoader {
    private final List<Pattern> whitelist;
    private final List<Pattern> blacklist;

    public ApplicationClassLoader(URL[] urls, ClassLoader parent, List<Pattern> whitelist, List<Pattern> blackList) {
        super(urls, parent);
        System.setSecurityManager(null);
        this.whitelist = new ArrayList<Pattern>(whitelist);
        this.blacklist = new ArrayList<Pattern>(blackList);
    }

    public ApplicationClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, null, null);
    }

    public ApplicationClassLoader(URL[] urls) {
        this(urls, null, null, null);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            if (c == null) {
                if (this.isAllowed(name)) {
                    c = this.getParent().loadClass(name);
                }
                if (c == null) {
                    throw new ClassNotFoundException(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null && this.isAllowed(name)) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            if (url != null) {
                return url.openStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> res = this.findResources(name);
        if (res == null && this.getParent() != null && this.isAllowed(name)) {
            res = this.getParent().getResources(name);
        }
        return res;
    }

    private final boolean isAllowed(String name) {
        if (this.whitelist == null || this.whitelist.isEmpty()) {
            return !this.isBlackListed(name);
        }
        String packageName = name.replaceAll("\\.", "/");
        String resourceName = name.replaceAll("/", "\\.");
        for (Pattern pat : this.whitelist) {
            if (!pat.matcher(packageName).matches() && !pat.matcher(resourceName).matches()) continue;
            return !this.isBlackListed(name);
        }
        return false;
    }

    private final boolean isBlackListed(String name) {
        if (this.blacklist == null || this.blacklist.isEmpty()) {
            return false;
        }
        String packageName = name.replaceAll("\\.", "/");
        String resourceName = name.replaceAll("/", "\\.");
        for (Pattern pat : this.blacklist) {
            if (!pat.matcher(packageName).matches() && !pat.matcher(resourceName).matches()) continue;
            return true;
        }
        return false;
    }
}

