/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.AlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.AlgorithmVersionTransferable;
import csbase.client.applications.flowapplication.configurator.FlowAlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphListener;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.Grid;
import csbase.client.applications.flowapplication.messages.ChangeCursorMessage;
import csbase.client.applications.flowapplication.messages.ErrorMessage;
import csbase.client.applications.flowapplication.messages.HideHintMessage;
import csbase.client.applications.flowapplication.messages.SelectElementMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;
import csbase.client.applications.flowapplication.messages.ShowHintMessage;
import csbase.client.applications.flowapplication.messages.ShowPopupMessage;
import csbase.client.applications.flowapplication.zoom.AbstractZoomModel;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.BugException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.vix.Filter;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;

public final class Workspace
extends JPanel
implements TypeVS {
    private static final double DEFAULT_WIDTH = 400.0;
    private static final double DEFAULT_HEIGHT = 300.0;
    private static final int MARGIN = 10;
    private Graph graph;
    private final Grid grid;
    private final AffineTransform matrix = new AffineTransform();
    private TypeVO vo;
    private final ZoomModel zoomModel;
    private boolean autoCreateLinks;
    private boolean showVersion;
    private boolean fit;

    public Workspace(Window window, boolean useGrid, boolean zoomToFit) {
        this(new Graph(window), useGrid, zoomToFit);
    }

    public Workspace(Graph graph, boolean useGrid, boolean zoomToFit) {
        this.graph = graph;
        this.zoomModel = new VSZoomModel();
        this.autoCreateLinks = false;
        this.showVersion = false;
        if (useGrid) {
            this.setBackground(Color.WHITE);
        }
        this.fit = zoomToFit;
        this.grid = new Grid(this);
        this.grid.setEnabled(useGrid);
        this.graph.changeVS(null, (TypeVS)this.grid);
        this.changeVO(null, (TypeVO)this.grid);
        this.grid.changeVO(null, (TypeVO)this.graph);
        this.addAncestorListener(new VSAncestorListener());
        this.addComponentListener(new VSComponentListener());
        this.addMouseListener(new VSMouseListener());
        this.addMouseMotionListener(new VSMouseMotionListener());
        this.addKeyListener(new VSKeyListener());
        this.graph.addGraphListener(new VSGraphListener());
        this.graph.setVersionInfoVisible(this.showVersion);
        new DropTarget(this, new VSDropTargetListener());
        if (this.fit) {
            this.adjustZoomToFit();
        }
    }

    public void attachFilter(Filter filter) {
        filter.changeVO(null, this.vo);
        filter.changeVS(null, (TypeVS)this);
        this.vo.changeVS(null, (TypeVS)filter);
        this.changeVO(null, (TypeVO)filter);
    }

    public boolean changeVO(TypeVO oldvo, TypeVO newvo) {
        if (oldvo == null) {
            this.vo = newvo;
            return true;
        }
        if (!oldvo.equals(this.vo)) {
            return false;
        }
        this.vo = newvo;
        return true;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graphics2D getGraphics2D() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g != null) {
            g.transform(this.matrix);
        }
        return g;
    }

    public ZoomModel getZoomModel() {
        return this.zoomModel;
    }

    public boolean msgHandlerVS(TypeMessage msg) {
        if (msg instanceof ErrorMessage) {
            this.handleErrorMessage((ErrorMessage)msg);
            return true;
        }
        if (msg instanceof ShowPopupMessage) {
            this.handleShowPopupMessage((ShowPopupMessage)msg);
            return true;
        }
        if (msg instanceof ShowHintMessage) {
            this.handleShowHintMessage((ShowHintMessage)msg);
            return true;
        }
        if (msg instanceof HideHintMessage) {
            this.handleHideHintMessage();
            return true;
        }
        if (msg instanceof ChangeCursorMessage) {
            this.handleChangeCursorMessage((ChangeCursorMessage)msg);
            return true;
        }
        return false;
    }

    public void adjustZoomToFit() {
        double fitValue = this.zoomModel.getFitValue();
        this.zoomModel.setValue(fitValue);
    }

    public boolean sendVO(TypeMessage msg) {
        if (this.vo == null) {
            return false;
        }
        return msg.sendVO(this.vo);
    }

    public void setGraph(Graph graph) {
        graph.addGraphListeners(this.graph.getGraphListenerList());
        this.graph.clearGraphListeners();
        this.graph = graph;
        this.graph.changeVS(null, (TypeVS)this.grid);
        this.grid.changeVO(null, (TypeVO)this.graph);
        this.graph.nodeValidation(ValidationMode.FULL, true);
        this.graph.notifyChangedWorkspace();
        this.graph.addGraphListener(new VSGraphListener());
        this.graph.setVersionInfoVisible(this.showVersion);
        this.updateSize();
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.vo != null) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.transform(this.matrix);
            this.vo.callbackRepaint((Graphics2D)g);
        }
    }

    private String getString(String msgKey) {
        return LNG.get((String)(Workspace.class.getName() + "." + msgKey));
    }

    private void handleChangeCursorMessage(ChangeCursorMessage message) {
        this.setCursor(message.getCursor());
    }

    private void handleErrorMessage(ErrorMessage message) {
        String key = message.getKey();
        if (key != null) {
            Object[] arguments = message.getArguments();
            String errorMessage = arguments == null ? LNG.get((String)key) : LNG.get((String)key, (Object[])arguments);
            this.showWarningDialog(errorMessage);
        } else {
            this.showErrorDialog(message.getException());
        }
    }

    private void handleHideHintMessage() {
        if (this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
    }

    private void handleShowHintMessage(ShowHintMessage message) {
        if (!message.getHint().equals(this.getToolTipText())) {
            this.setToolTipText(message.getHint());
        }
    }

    private void handleShowPopupMessage(ShowPopupMessage message) {
        JPopupMenu popupMenu = new JPopupMenu();
        List<JComponent> components = message.getPopupComponentList();
        if (!components.isEmpty()) {
            for (JComponent component : components) {
                popupMenu.add(component);
            }
            Point2D point = message.getPoint();
            this.matrix.transform(point, point);
            popupMenu.show(this, (int)point.getX(), (int)point.getY());
        }
    }

    private void importAlgorithmConfigurator(AlgorithmConfiguratorView view, Point point) {
        if (view == null) {
            return;
        }
        if (view instanceof FlowAlgorithmConfiguratorView) {
            FlowAlgorithmConfiguratorView flowView = (FlowAlgorithmConfiguratorView)view;
            this.importFlowAlgorithmConfigurator(flowView, point);
        } else {
            GraphNode node = this.graph.createGraphNode(view, point, false);
            new SelectElementMessage(node, point).sendVO(this.vo);
            if (this.autoCreatesLinks()) {
                this.createLinks(node);
            }
        }
    }

    private void createLinks(GraphNode node) {
        Collection<GraphNode> nodeCollection;
        Map<String, GraphFileDescriptor> inputs = this.getUniqueAvailableInputs(node);
        if (!inputs.isEmpty() && (nodeCollection = this.graph.getNodeCollection()).size() > 1) {
            HashMap<String, GraphFileDescriptor> outputs = new HashMap<String, GraphFileDescriptor>();
            for (GraphNode graphNode : nodeCollection) {
                if (graphNode.equals(node)) continue;
                Map<String, GraphFileDescriptor> nodeOutputs = this.getUniqueAvailableOutputs(graphNode);
                for (Map.Entry<String, GraphFileDescriptor> entry : nodeOutputs.entrySet()) {
                    GraphFileDescriptor oldValue = outputs.put(entry.getKey(), entry.getValue());
                    if (oldValue == null) continue;
                    return;
                }
            }
            if (outputs.size() > 0) {
                for (Map.Entry entry : inputs.entrySet()) {
                    String fileType = (String)entry.getKey();
                    if (!outputs.containsKey(fileType)) continue;
                    List<Point2D> emptyList = Collections.emptyList();
                    GraphFileDescriptor output = (GraphFileDescriptor)((Object)outputs.get(fileType));
                    GraphFileDescriptor input = (GraphFileDescriptor)((Object)entry.getValue());
                    AbstractFileParameter outputParam = output.getFileParameter();
                    AbstractFileParameter inputParam = input.getFileParameter();
                    if (outputParam == null || inputParam == null || outputParam.getMode() != inputParam.getMode()) continue;
                    this.graph.createGraphLink(input, output, emptyList);
                }
            }
        }
    }

    private Map<String, GraphFileDescriptor> getUniqueAvailableOutputs(GraphNode node) {
        HashMap<String, GraphFileDescriptor> outputs = new HashMap<String, GraphFileDescriptor>();
        Collection<GraphFileDescriptor> outputFiles = node.getOutputFileDescriptorCollection();
        for (GraphFileDescriptor output : outputFiles) {
            String fileType;
            GraphFileDescriptor oldValue;
            AbstractFileParameter fileParameter = output.getFileParameter();
            if (!output.getLinkFromCollection().isEmpty() || !this.canInferLink(fileParameter) || (oldValue = outputs.put(fileType = fileParameter.getMode() == FileParameterMode.DIRECTORY ? FileParameterMode.DIRECTORY.toString() : fileParameter.getFileType(), output)) == null) continue;
            return Collections.emptyMap();
        }
        return outputs;
    }

    private Map<String, GraphFileDescriptor> getUniqueAvailableInputs(GraphNode node) {
        HashMap<String, GraphFileDescriptor> inputs = new HashMap<String, GraphFileDescriptor>();
        for (GraphFileDescriptor input : node.getInputFileDescriptorCollection()) {
            String fileType;
            GraphFileDescriptor oldValue;
            AbstractFileParameter fileParameter = input.getFileParameter();
            if (input.getLinkTo() != null || !this.canInferLink(fileParameter) || (oldValue = inputs.put(fileType = fileParameter.getMode() == FileParameterMode.DIRECTORY ? FileParameterMode.DIRECTORY.toString() : fileParameter.getFileType(), input)) == null) continue;
            return Collections.emptyMap();
        }
        return inputs;
    }

    private boolean canInferLink(AbstractFileParameter fileParameter) {
        return fileParameter != null && fileParameter.getValue() == null && fileParameter.usesPipe() != FileParameterPipeAcceptance.FALSE && fileParameter.isEnabled() && fileParameter.isVisible();
    }

    private void importFlowAlgorithmConfigurator(FlowAlgorithmConfiguratorView flowAlgorithmConfiguratorView, Point dropPosition) {
        Graph flowGraph = flowAlgorithmConfiguratorView.getGraph();
        Collection<GraphElement> elements = this.graph.merge(flowGraph);
        new SelectElementsMessage(elements).sendVO(this.vo);
        Rectangle2D bounds = flowGraph.getBounds2D();
        if (bounds != null) {
            double centerX = bounds.getCenterX();
            double centerY = bounds.getCenterY();
            double dx = dropPosition.getX() - centerX;
            double dy = dropPosition.getY() - centerY;
            for (GraphElement element : elements) {
                Rectangle2D elementBounds = element.getBounds2D();
                if (dx < 0.0) {
                    dx = Math.max(dx, -1.0 * elementBounds.getMinX());
                }
                if (!(dy < 0.0)) continue;
                dy = Math.max(dy, -1.0 * elementBounds.getMinY());
            }
            for (GraphElement element : elements) {
                element.drag(dx, dy);
            }
            for (GraphElement element : elements) {
                element.drop();
            }
            this.repaint();
        }
    }

    private void inverse(Point2D pt) {
        try {
            this.matrix.inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    private void resizeGrid() {
        if (this.grid != null) {
            double minX = 0.0;
            double minY = 0.0;
            double maxX = this.getBounds().getMaxX();
            double maxY = this.getBounds().getMaxY();
            Rectangle2D bounds = this.graph.getBounds2D();
            if (bounds != null) {
                maxX = Math.max(maxX, bounds.getMaxX() + 10.0);
                maxY = Math.max(maxY, bounds.getMaxY() + 10.0);
            }
            this.grid.setBounds2D(0.0, 0.0, maxX *= 1.0 / this.zoomModel.getValue(), maxY *= 1.0 / this.zoomModel.getValue());
            this.repaint();
        }
    }

    private void showErrorDialog(Exception exception) {
        Window window = SwingUtilities.getWindowAncestor(this);
        StandardErrorDialogs.showErrorDialog(window, this.getString("error"), (Throwable)exception);
    }

    private void showWarningDialog(String message) {
        Window window = SwingUtilities.getWindowAncestor(this);
        StandardDialogs.showWarningDialog((Component)window, (String)this.getString("error"), (String)message);
    }

    private void updateSize() {
        Rectangle2D bounds = this.graph.getBounds2D();
        if (bounds != null) {
            Dimension newPreferredSize = new Dimension();
            if (this.fit) {
                double zoomValue = this.getZoomModel().getValue();
                double tx = -bounds.getMinX() * zoomValue;
                double ty = -bounds.getMinY() * zoomValue;
                this.matrix.setTransform(zoomValue, 0.0, 0.0, zoomValue, tx, ty);
                double newWidth = bounds.getWidth() * zoomValue;
                double newHeight = bounds.getHeight() * zoomValue;
                newPreferredSize.setSize(newWidth, newHeight);
            } else {
                double newWidth = (bounds.getX() + bounds.getWidth() + 10.0) * this.zoomModel.getValue();
                double newHeight = (bounds.getY() + bounds.getHeight() + 10.0) * this.zoomModel.getValue();
                newPreferredSize.setSize(newWidth, newHeight);
            }
            this.setPreferredSize(newPreferredSize);
            this.revalidate();
        }
        this.resizeGrid();
    }

    public void addNewNode(AlgorithmVersionInfo algorithmVersionInfo) {
        Point position = this.graph.findPositionForNewNode();
        this.addNewNode(algorithmVersionInfo, position);
    }

    public void importConfigurator(AlgorithmConfigurator configurator) {
        if (configurator == null) {
            return;
        }
        Point position = this.graph.findPositionForNewNode();
        Window window = SwingUtilities.getWindowAncestor(this);
        AlgorithmConfiguratorView view = AlgorithmConfiguratorFactory.getInstance().createConfigurationView(window, configurator.getAlgorithmVersion(), ValidationMode.ALLOW_EMPY_VALUES);
        if (view == null) {
            return;
        }
        Map parameterValues = configurator.exportValues();
        AlgorithmConfigurator newConfigurator = view.getConfigurator();
        try {
            newConfigurator.importValues(parameterValues);
        }
        catch (ParseException e) {
            throw new BugException((Throwable)e);
        }
        this.importAlgorithmConfigurator(view, position);
    }

    public void addNewNode(AlgorithmVersionInfo algorithmVersionInfo, Point position) {
        if (algorithmVersionInfo == null) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        AlgorithmConfiguratorView algorithmConfiguratorView = AlgorithmConfiguratorFactory.getInstance().createConfigurationView(window, algorithmVersionInfo, ValidationMode.ALLOW_EMPY_VALUES);
        if (algorithmConfiguratorView == null) {
            return;
        }
        this.importAlgorithmConfigurator(algorithmConfiguratorView, position);
    }

    public void setAutoCreateLinks(boolean autoCreate) {
        this.autoCreateLinks = autoCreate;
    }

    public void setVersionInfoVisible(boolean visible) {
        this.showVersion = visible;
        this.graph.setVersionInfoVisible(visible);
    }

    public boolean autoCreatesLinks() {
        return this.autoCreateLinks;
    }

    private final class VSZoomModel
    extends AbstractZoomModel {
        private static final double STANDARD_ZOOM_VALUE = 1.0;
        private static final double MAX_ZOOM_VALUE = 4.0;
        private static final double MIN_ZOOM_VALUE = 0.2;
        private double zoom;

        public VSZoomModel() {
            super(0.2, 4.0, 1.0, 0.01, 0.1);
            this.zoom = 1.0;
        }

        @Override
        public double getFitValue() {
            double graphHeight;
            double graphWidth;
            Rectangle workspaceBounds = Workspace.this.getVisibleRect();
            if (workspaceBounds.isEmpty()) {
                return this.getStandardValue();
            }
            double workspaceWidth = workspaceBounds.getWidth();
            double workspaceHeight = workspaceBounds.getHeight();
            Rectangle2D graphBounds = Workspace.this.graph.getBounds2D();
            if (graphBounds == null) {
                graphWidth = 400.0;
                graphHeight = 300.0;
            } else {
                graphWidth = graphBounds.getWidth() + 10.0;
                graphHeight = graphBounds.getHeight() + 10.0;
            }
            double widthRatio = workspaceWidth / graphWidth;
            double heightRatio = workspaceHeight / graphHeight;
            double ratio = 1.0;
            if (widthRatio < 1.0 || heightRatio < 1.0) {
                ratio = Math.min(widthRatio, heightRatio);
                ratio = Math.floor(ratio * 100.0) / 100.0;
            }
            return ratio;
        }

        @Override
        public double getValue() {
            return this.zoom;
        }

        @Override
        protected void changeValue(double value) {
            Workspace.this.matrix.setToIdentity();
            Workspace.this.matrix.scale(value, value);
            this.zoom = value;
            Workspace.this.updateSize();
            Workspace.this.repaint();
        }
    }

    private final class VSMouseMotionListener
    implements MouseMotionListener {
        private VSMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            boolean isLeft = SwingUtilities.isLeftMouseButton(ev);
            if (isLeft && Workspace.this.vo != null) {
                Point2D.Double pt = new Point2D.Double(ev.getX(), ev.getY());
                Workspace.this.inverse(pt);
                Workspace.this.vo.callbackDrag((Point2D)pt, ev);
            }
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            if (Workspace.this.vo != null) {
                Point2D.Double pt = new Point2D.Double(ev.getX(), ev.getY());
                Workspace.this.inverse(pt);
                Workspace.this.vo.callbackMove((Point2D)pt, ev);
            }
        }
    }

    private final class VSMouseListener
    extends MouseAdapter {
        private VSMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            this.handleMouseButtonEvent(ev);
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.handleMouseButtonEvent(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.handleMouseButtonEvent(ev);
        }

        private void handleMouseButtonEvent(MouseEvent ev) {
            Workspace.this.requestFocusInWindow();
            if (Workspace.this.vo != null) {
                Point2D.Float pt = new Point2D.Float(ev.getX(), ev.getY());
                Workspace.this.inverse(pt);
                Workspace.this.vo.callbackButton((Point2D)pt, ev);
            }
        }
    }

    private final class VSKeyListener
    implements KeyListener {
        private VSKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (Workspace.this.vo != null) {
                Workspace.this.vo.callbackKey(ev);
            }
        }

        @Override
        public void keyReleased(KeyEvent ev) {
            if (Workspace.this.vo != null) {
                Workspace.this.vo.callbackKey(ev);
            }
        }

        @Override
        public void keyTyped(KeyEvent ev) {
            if (Workspace.this.vo != null) {
                Workspace.this.vo.callbackKey(ev);
            }
        }
    }

    private final class VSGraphListener
    implements GraphListener {
        private VSGraphListener() {
        }

        @Override
        public void wasChangedWorkspace(Graph workGraph) {
            Workspace.this.updateSize();
        }

        @Override
        public void wasElementCreated(Graph workGraph, GraphElement element) {
            Workspace.this.updateSize();
        }

        @Override
        public void wasElementDragged(Graph workGraph, GraphElement element, double tx, double ty) {
        }

        @Override
        public void wasElementDragged(Graph workGraph, GraphElement element, Point2D startPoint, Point2D endPoint) {
        }

        @Override
        public void wasElementDropped(Graph workGraph, GraphElement element, Point2D point) {
            Workspace.this.updateSize();
        }

        @Override
        public void wasElementParametrized(Graph workGraph, GraphElement element) {
        }

        @Override
        public void wasElementRemoved(Graph workGraph, GraphElement element) {
            Workspace.this.updateSize();
        }

        @Override
        public void wasElementSelected(Graph workGraph, GraphElement element) {
        }

        @Override
        public void wasLinkAnchored(Graph workGraph, GraphLink link, GraphFileDescriptor fileDescriptor) {
        }

        @Override
        public void wasLinkIncreased(Graph workGraph, GraphLink link) {
            Workspace.this.updateSize();
        }

        @Override
        public void wasLinkStatusChanged(Graph workGraph, GraphLink link) {
        }

        @Override
        public void wasLinkUnanchored(Graph workGraph, GraphLink link, GraphFileDescriptor fileDescriptor) {
        }

        @Override
        public void wasNodeResized(Graph workGraph, GraphNode node) {
            Workspace.this.updateSize();
        }

        @Override
        public void wasParameterSetEnabled(Graph workGraph, GraphNode node, String parameterName, boolean isEnabled) {
        }

        @Override
        public void wasReseted(Graph workGraph) {
        }

        @Override
        public void wasParameterSetVisible(Graph workGraph, GraphNode node, String parameterName, boolean isVisible) {
        }
    }

    private final class VSDropTargetListener
    implements DropTargetListener {
        private VSDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(AlgorithmVersionTransferable.DATA_FLAVOR)) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            AlgorithmVersionInfo algorithmVersionInfo;
            Workspace.this.requestFocusInWindow();
            Point dropPosition = dtde.getLocation();
            Workspace.this.inverse(dropPosition);
            Transferable transferable = dtde.getTransferable();
            if (!transferable.isDataFlavorSupported(AlgorithmVersionTransferable.DATA_FLAVOR)) {
                return;
            }
            try {
                algorithmVersionInfo = (AlgorithmVersionInfo)transferable.getTransferData(AlgorithmVersionTransferable.DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                Workspace.this.showErrorDialog(e);
                return;
            }
            Workspace.this.addNewNode(algorithmVersionInfo, dropPosition);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }

    private final class VSComponentListener
    extends ComponentAdapter {
        private VSComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Workspace.this.resizeGrid();
            Workspace.this.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            Workspace.this.resizeGrid();
            Workspace.this.repaint();
        }
    }

    private final class VSAncestorListener
    implements AncestorListener {
        private VSAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            if (Workspace.this.fit) {
                Workspace.this.adjustZoomToFit();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

