/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import com.kitfox.svg.app.beans.SVGIcon;
import csbase.client.applications.flowapplication.SVGVO;
import csbase.client.applications.flowapplication.graph.AbstractGraphNodeDecoration;
import csbase.client.applications.flowapplication.graph.GraphImages;
import csbase.client.applications.flowapplication.graph.GraphNodeDecoration;
import java.awt.geom.Rectangle2D;
import tecgraf.javautils.core.lng.LNG;

public class GraphNodeImageDecoration
extends AbstractGraphNodeDecoration<SVGVO> {
    protected DecorationType type;

    public GraphNodeImageDecoration() {
        super(null, "");
        this.type = DecorationType.BLANK;
    }

    public GraphNodeImageDecoration(DecorationType type, SVGVO image, String description) {
        super(image, description);
        if (image != null) {
            image.setVerticalAlignment(SVGVO.VerticalAlignment.CENTER);
            image.setHorizontalAlignment(SVGVO.HorizontalAlignment.RIGHT);
        }
        this.type = type;
    }

    public DecorationType getType() {
        return this.type;
    }

    public void setType(DecorationType type) {
        this.type = type;
    }

    public static GraphNodeDecoration<SVGVO> createDecoration(DecorationType type) {
        switch (type) {
            case SCHEDULED: {
                return GraphNodeImageDecoration.createScheduledDecoration();
            }
            case SYSTEM_FAILURE: {
                return GraphNodeImageDecoration.createSystemFailureDecoration();
            }
            case EXECUTION: {
                return GraphNodeImageDecoration.createExecutingDecoration();
            }
            case EXECUTION_ERROR: {
                return GraphNodeImageDecoration.createExecutionErrorDecoration();
            }
            case EXECUTION_SUCCESS: {
                return GraphNodeImageDecoration.createExecutionSuccessDecoration();
            }
            case EXECUTION_UNKNOWN: {
                return GraphNodeImageDecoration.createExecutionUnknownDecoration();
            }
            case INTERRUPTED: {
                return GraphNodeImageDecoration.createInterruptedDecoration();
            }
            case NON_FATAL_ERROR: {
                return GraphNodeImageDecoration.createNonFatalErrorDecoration();
            }
            case FATAL_ERROR: {
                return GraphNodeImageDecoration.createFatalErrorDecoration();
            }
        }
        return GraphNodeImageDecoration.createNullDecoration();
    }

    private static GraphNodeDecoration<SVGVO> createScheduledDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.SCHEDULED, GraphImages.ICON_SCHEDULED, "algorithms.tooltip.scheduled");
    }

    private static GraphNodeDecoration<SVGVO> createInterruptedDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.INTERRUPTED, GraphImages.ICON_INTERRUPTED, "algorithms.tooltip.interrupted");
    }

    private static GraphNodeDecoration<SVGVO> createNonFatalErrorDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.NON_FATAL_ERROR, GraphImages.ICON_NON_FATAL_ERROR, "algorithms.tooltip.non_fatal_error");
    }

    private static GraphNodeDecoration<SVGVO> createFatalErrorDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.FATAL_ERROR, GraphImages.ICON_FATAL_ERROR, "algorithms.tooltip.fatal_error");
    }

    private static GraphNodeDecoration<SVGVO> createSystemFailureDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.SYSTEM_FAILURE, GraphImages.ICON_SYSTEM_FAILURE, "algorithms.tooltip.system_failure");
    }

    private static GraphNodeDecoration<SVGVO> createExecutingDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.EXECUTION, GraphImages.ICON_EXECUTING, "algorithms.tooltip.executing");
    }

    private static GraphNodeDecoration<SVGVO> createExecutionSuccessDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.EXECUTION_SUCCESS, GraphImages.ICON_SUCCESS, "algorithms.tooltip.execution_end.success");
    }

    private static GraphNodeDecoration<SVGVO> createExecutionErrorDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.EXECUTION_ERROR, GraphImages.ICON_ERROR, "algorithms.tooltip.execution_end.error");
    }

    private static GraphNodeDecoration<SVGVO> createExecutionUnknownDecoration() {
        return GraphNodeImageDecoration.createDecoration(DecorationType.EXECUTION_UNKNOWN, GraphImages.ICON_NO_CODE, "algorithms.tooltip.execution_end.no_code");
    }

    private static GraphNodeDecoration<SVGVO> createNullDecoration() {
        return new GraphNodeImageDecoration();
    }

    private static GraphNodeDecoration<SVGVO> createDecoration(DecorationType type, SVGIcon image, String key) {
        return new GraphNodeImageDecoration(type, new SVGVO(image), LNG.get((String)key));
    }

    @Override
    public void setRectangle(Rectangle2D.Double rect) {
        if (this.vo != null) {
            ((SVGVO)this.vo).setRectangle(rect);
        }
    }

    public static enum DecorationType {
        SYSTEM_FAILURE,
        SCHEDULED,
        EXECUTION,
        EXECUTION_ERROR,
        EXECUTION_SUCCESS,
        EXECUTION_UNKNOWN,
        INTERRUPTED,
        NON_FATAL_ERROR,
        FATAL_ERROR,
        BLANK;

    }
}

