/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.externalresources.ExternalResources;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.remote.srvproxies.HttpProxy;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonFileDownloadAction
extends CommonProjectAction {
    private boolean isFileFromTree;
    private ClientProjectFile exportFile;

    public CommonFileDownloadAction(ProjectFileContainer container) {
        super(container);
        this.isFileFromTree = true;
    }

    public CommonFileDownloadAction(ProjectFileContainer container, ClientProjectFile file) {
        super(container);
        this.isFileFromTree = false;
        this.exportFile = file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClientProjectFile file = this.isFileFromTree ? this.getSelectedFile() : this.exportFile;
        User user = User.getLoggedUser();
        CommonClientProject project = this.getProject();
        final Window window = this.getWindow();
        try {
            String addr = HttpProxy.getDownloadURL(project.getId(), file.getPath());
            if (addr == null) {
                StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_URL_ERROR"));
                return;
            }
            final URL url = new URL(addr);
            if (ExternalResources.getInstance().isEnabled()) {
                ExternalResources.getInstance().showDocument(url);
                return;
            }
            try {
                JFileChooser chooser = new JFileChooser();
                final String errorMsg = LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_IO_ERROR");
                try {
                    int returnVal = chooser.showSaveDialog(window);
                    if (returnVal == 0) {
                        File fileChoosed = chooser.getSelectedFile();
                        final FileOutputStream newFile = new FileOutputStream(fileChoosed);
                        final String fileName = fileChoosed.getName();
                        final Object[] ids = new Object[]{user.getId()};
                        Thread work = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    int i;
                                    String title = LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_TITLE");
                                    Object[] args = new Object[]{fileName};
                                    String fmtStart = LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_START");
                                    String msg = MessageFormat.format(fmtStart, args);
                                    StandardDialogs.showInfoDialog((Component)window, (String)title, (Object)msg);
                                    InputStream urlIn = url.openStream();
                                    BufferedInputStream in = new BufferedInputStream(urlIn);
                                    byte[] b = new byte[1024];
                                    while ((i = ((InputStream)in).read(b)) != -1) {
                                        newFile.write(b, 0, i);
                                    }
                                    urlIn.close();
                                    String fmtOk = LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_SUCCESS");
                                    msg = MessageFormat.format(fmtOk, args);
                                    NotificationProxy.notifyTo(ids, msg, false, false);
                                    newFile.close();
                                }
                                catch (Exception ex) {
                                    StandardErrorDialogs.showErrorDialog(window, errorMsg, (Throwable)ex);
                                    return;
                                }
                            }
                        };
                        work.start();
                    }
                }
                catch (Exception ioEx) {
                    StandardErrorDialogs.showErrorDialog(window, errorMsg, (Throwable)ioEx);
                }
            }
            catch (Exception appletEx) {
                StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_APPLET_ERROR"), (Throwable)appletEx);
            }
        }
        catch (Exception URLEx) {
            StandardErrorDialogs.showErrorDialog(window, LNG.get((String)"PRJ_PROJECT_FILE_DOWNLOAD_URL_ERROR"), (Throwable)URLEx);
            return;
        }
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_DOWNLOAD_FILE");
    }
}

