/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.filters;

import csbase.client.project.ClientProjectFileType;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;
import java.util.List;
import javax.swing.ImageIcon;

public class ClientFileSingleTypeFilter
implements ClientFileFilterInterface {
    private final String type;

    public ClientFileSingleTypeFilter(String type) {
        this.type = type;
    }

    @Override
    public boolean accept(ClientFile file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getType().equals(this.type);
    }

    @Override
    public String getDescription() {
        ClientProjectFileType fileType = ClientProjectFileType.getFileType(this.type);
        String desc = fileType.getDescription();
        List extensions = fileType.getExtensions();
        String extSufix = "(";
        for (String ext : extensions) {
            extSufix = extSufix + " *." + ext + " ";
        }
        extSufix = extSufix + ")";
        return this.type + ": " + desc + " - " + extSufix;
    }

    @Override
    public ImageIcon getImageIcon() {
        ClientProjectFileType fileType = ClientProjectFileType.getFileType(this.type);
        return fileType.getBaseIcon();
    }

    @Override
    public ProjectFileType inferFileType() {
        ProjectFileType tp = ProjectFileType.getFileType((String)this.type);
        return tp;
    }
}

