/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log.tab;

import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.AutoReloadable;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.tab.AbstractTab;
import csbase.client.util.gui.log.tab.ReloadableTab;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import tecgraf.javautils.gui.StatusBar;

public abstract class AbstractLogTab
extends AbstractTab
implements ReloadableTab,
AutoReloadable {
    protected final AtomicBoolean wasNeverSelected;
    protected final AtomicBoolean updateAutoReloadStatus;
    protected final AtomicBoolean autoReload;
    protected final LogPanelReloader reloader;
    protected final StatusBar statusBar;

    public AbstractLogTab(String title, StatusBar statusBar, Window owner, boolean reload) {
        super(AbstractTab.TabType.RELOADABLE, title, owner);
        this.initialize();
        this.statusBar = statusBar;
        this.reloader = this.createReloader();
        this.wasNeverSelected = new AtomicBoolean(true);
        this.updateAutoReloadStatus = new AtomicBoolean(false);
        this.autoReload = new AtomicBoolean(reload);
        this.reloader.addStopEventListener(new EventListener<LogPanelReloader.StopEvent>(){

            @Override
            public void eventFired(LogPanelReloader.StopEvent event) {
                AbstractLogTab.this.setAutoReload(false);
            }
        });
        this.reloader.addStartEventListener(new EventListener<LogPanelReloader.StartEvent>(){

            @Override
            public void eventFired(LogPanelReloader.StartEvent event) {
                AbstractLogTab.this.setAutoReload(true);
            }
        });
    }

    private void setAutoReload(boolean reload) {
        if (!this.updateAutoReloadStatus.compareAndSet(true, false)) {
            this.autoReload.set(reload);
        }
    }

    protected void initialize() {
    }

    protected LogPanelReloader createReloader() {
        return new LogPanelReloader(this);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        boolean ignoreReloader = !this.wasNeverSelected.get();
        this.wasNeverSelected.compareAndSet(true, !selected);
        if (!this.autoReload.get()) {
            return;
        }
        this.updateAutoReloadStatus.set(ignoreReloader);
        if (selected) {
            this.reloader.start();
        } else {
            this.reloader.stop();
        }
    }

    @Override
    public LogPanelReloader getReloader() {
        return this.reloader;
    }
}

