package csbase.client.applications.algorithmsmanager.actions;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;

/**
 * Essa classe representa a ao de remover uma verso de algoritmo, na
 * funcionalidade de gerenciamento de algoritmos.
 * 
 * O mtodo <code> handleEditOperation </code> deve ser redefinido para que seja
 * aberto o dilogo para confirmao da remoo da verso do algoritmo.
 * 
 */
public class VersionDuplicateAction extends CommonVersionAction {

  /**
   * Constri a ao de importar um pacote de verso de algoritmo.
   * 
   * @param versionInfoPanel painel pai que criou a ao
   * @param icon imagem da ao
   */
  public VersionDuplicateAction(AlgorithmVersionInfoPanel versionInfoPanel,
    ImageIcon icon) {
    super(versionInfoPanel, icon);
  }

  @Override
  protected void handleVersionOperation() {
    new DuplicateVersionDialog().show();
  }

  /**
   * Classe que representa um dilogo de duplicao de verses.
   * 
   * @author Leonardo Barros
   */
  private class DuplicateVersionDialog extends VersionDialog {

    /**
     * Cria o dilogo.
     */
    public DuplicateVersionDialog() {
      super(getSelectedAlgorithm());
    }

    /**
     * Exibe o dilogo.
     */
    public void show() {
      dialogTitle =
        String.format(LNG.get("algomanager.title.include_version"),
          algoInfo.getName());
      dialog = new DesktopComponentDialog(getWindow());
      dialog.setTitle(dialogTitle);
      dialog.addWindowListener(new WindowAdapter() {
        @Override
        public void windowClosing(WindowEvent e) {
          dialog.close();
        }
      });

      JPanel infoPanel = new JPanel();
      JLabel idLabel = new JLabel(LNG.get("algomanager.label.version_id"));
      majorField = new JTextField(3);
      minorField = new JTextField(3);
      patchField = new JTextField(3);
      infoPanel.add(idLabel);
      infoPanel.add(majorField);
      infoPanel.add(minorField);
      infoPanel.add(patchField);
      JPanel buttonsPanel = new JPanel();
      JButton includeButton =
        new JButton(LNG.get("algomanager.button.include"));
      includeButton.addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
          int[] vNumbers = getVersionNumbers();
          if (vNumbers != null) {
            duplicateVersion(getSelectedVersion().getId(), vNumbers[0],
              vNumbers[1], vNumbers[2]);
            dialog.close();
          }
        }
      });

      JButton cancelButton = new JButton(LNG.get("algomanager.button.cancel"));
      cancelButton.addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
          dialog.close();
        }
      });
      ClientUtilities.adjustEqualSizes(includeButton, cancelButton);
      buttonsPanel.add(includeButton);
      buttonsPanel.add(cancelButton);
      Container cp = dialog.getContentPane();
      cp.add(infoPanel, BorderLayout.CENTER);
      cp.add(buttonsPanel, BorderLayout.SOUTH);
      dialog.pack();
      dialog.center(getWindow());
      dialog.setVisible(true);
    }

    /**
     * Duplica a verso especificada.
     * 
     * @param versionId identificador da verso a ser duplicada.
     * @param major nmero de verso da duplicata.
     * @param minor nmero de reviso da duplicata.
     * @param patch nmero de correo da duplicata.
     */
    private void duplicateVersion(Object versionId, int major, int minor,
      int patch) {
      Object algoId = algoInfo.getId();
      AlgorithmManagementProxy.duplicateVersion(algoId, versionId, major,
        minor, patch, getWindow());
    }
  }
}
