package csbase.client.applications.algorithmsmanager.models;

import javax.swing.Icon;

/**
 * Interface que modela os dados a serem usados na gerncia de categorias de
 * algoritmos.
 * 
 */
public interface DataInterface {
  /**
   * Obtm o nome do dado.
   * 
   * @return o nome do dado
   */
  public String getName();

  /**
   * Obtm o identificador do n
   * 
   * @return o identificador do n
   */
  public String getId();

  /**
   * Obtm o nome completo a ser exibido para o dado.
   * 
   * Por exemplo, se for uma subcategoria, poderia ser retornado
   * "categoria_pai:subcategoria".
   * 
   * @return o nome completo a ser exibido para o dado
   */
  public String getFullName();

  /**
   * Obtm o cone do n a ser desenhado na rvore de dados.
   * 
   * @return o cone que representa o n
   */
  public Icon getIcon();
}
