package csbase.client.applications.projectsynchronization;

import csbase.logic.ProjectSynchronizationData;
import csbase.logic.applicationservice.ApplicationRegistry;

import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.WizardException;

import java.text.MessageFormat;

import java.util.List;

public class StepSelectionFilesA extends StepSelectionFiles {
  protected ProjectSynchronizationData data;

  StepSelectionFilesA(ApplicationRegistry registry) {
    super(registry);
  }

  protected void enter(History history)
  throws WizardException {
    super.enter(history);
    data = (ProjectSynchronizationData)history.get(null, "data");
    String error = (String)history.get(null, "error");
    if (error != null) {
      throw new WizardException(error);
    }
    completeContainerSelection(data.getUnitA().getFiles(), null);
  }

  protected String getInstruction() {
    return MessageFormat.format(
      registry.getString("instruction.step3"),
      new Object[] { projectNameA, serverNameA, projectNameB, serverNameB });
  }

  protected Class getNext(History arg0) {
    return StepSelectionFilesB.class;
  }

  protected String getTitle() {
    return MessageFormat.format(
      registry.getString("title.step3"),
      new Object[] { projectNameA, serverNameA });
  }

  protected void exit(History history) {
    List selectedItems = confirmSelection(data.getUnitA().getFiles());
    history.addGlobal("selectedItems", selectedItems);
  }
}
