/*
 * $Id: BasicProjectTreeFactory.java 144754 2013-09-19 21:38:30Z mjulia $
 */
package csbase.client.project;

import java.awt.Window;

import csbase.client.kernel.ClientException;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;

/**
 * Esta classe  uma implementao bsica (ou mnima) de uma fbrica de rvore
 * de projetos, para clientes de sistemas desenvolvidos a partir do CSBASE.
 * 
 * A instncia dessa classe  um objeto "singleton", cuja referncia  obtida
 * atravs do mtodo getInstance (definido na superclasse).
 * 
 * @author Tecgraf/PUC-Rio
 */
public class BasicProjectTreeFactory extends ProjectTreeFactory {

  /**
   * Cria uma viso da rvore sem um projeto associado.
   * 
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   */
  @Override
  public ProjectTree makeProjectTree(Window owner, String title)
    throws ClientException {
    return new BasicProjectTree(owner, title);
  }

  /**
   * Cria uma viso da rvore de um projeto especfico.
   * 
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   * @param project projeto cuja rvore ser exibida
   */
  @Override
  public ProjectTree makeProjectTree(Window owner, String title,
    CommonClientProject project) throws ClientException {
    return new BasicProjectTree(owner, title, project);
  }

  /**
   * Cria uma viso da rvore de um projeto especfico, com o uso de um filtro.
   * 
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   * @param project projeto cuja rvore ser exibida
   * @param filter filtro usado para exibir a rvore
   */
  @Override
  public ProjectTree makeProjectTree(Window owner, String title,
    CommonClientProject project, ProjectFileFilter filter)
    throws ClientException {
    return new BasicProjectTree(owner, title, project, filter);
  }

  /**
   * Cria uma viso da rvore de um projeto especfico, com o uso de filtros de
   * visualizao e seleo de arquivos.
   * 
   * @param owner janela na qual a rvore  exibida
   * @param title ttulo da rvore
   * @param project projeto cuja rvore ser exibida
   * @param visualFilter filtro de visualizao
   * @param selectionFilter filtro de seleo
   */
  @Override
  public ProjectTree makeProjectTree(Window owner, String title,
    CommonClientProject project, ProjectFileFilter visualFilter,
    ProjectFileFilter selectionFilter) throws ClientException {
    return new BasicProjectTree(owner, title, project, visualFilter,
      selectionFilter);
  }
}
