/*
 * $Id: LinedTextArea.java 110339 2010-09-20 22:19:14Z clinio $
 */
package csbase.client.util.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

import javax.swing.JTextArea;

/**
 * @author Tecgraf/PUC-Rio
 */
public class LinedTextArea extends JTextArea {

  /**
   * Cor de fundo do frame
   */
  private Color frameBgColor = new Color(220, 220, 220);

  /**
   * Cor de texto do frame
   */
  private Color frameFgColor = new Color(000, 000, 180);

  /**
   * Cor do texo prefixo do frame
   */
  private Color prefixFgColor = new Color(150, 000, 000);

  /**
   * Texto prefixo
   */
  private String prefix = "x: ";

  /**
   * Nmero de caracteres do frame
   */
  private int numCharsFrameWidth = 5;

  /**
   * {@inheritDoc}
   */
  @Override
  public Insets getInsets() {
    return getInsets(new Insets(0, 0, 0, 0));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Insets getInsets(Insets insets) {
    Insets i = super.getInsets(insets);
    i.left += getLinePanelWidth();
    return i;
  }

  /**
   * Retorna a largura, em pixels, da largura do frame  esquerda com base em ,
   * pelo menos, 5 caracteres mais um de espao.
   * 
   * @return a largura
   */
  private int getLinePanelWidth() {
    final Font font = getFont();
    final FontMetrics fontMetrics = getFontMetrics(font);
    final String ch = "n";
    String rep = "";
    final int n = numCharsFrameWidth + prefix.length();
    for (int i = 0; i < n; i++) {
      rep = rep + ch;
    }
    return fontMetrics.stringWidth(rep);
  }

  /**
   * Consulta o nmero de caracteres a ser usado pelo frame
   * 
   * @param numChars o nmero de caracteres
   */
  final public void setNumCharsFrameWidth(final int numChars) {
    numCharsFrameWidth = numChars;
  }

  /**
   * Retorna o nmero de caracteres a ser usado pelo frame
   * 
   * @return o nmero de caracteres
   */
  final public int getNumCharsFrameWidth() {
    return numCharsFrameWidth;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void paintComponent(Graphics g) {
    final Insets insets = getInsets();
    final Rectangle clip = g.getClipBounds();

    g.setColor(getBackground());
    g.fillRect(clip.x, clip.y, clip.width, clip.height);

    // Verificando a necessidade de desenho das linhas
    if (clip.x >= insets.left) {
      super.paintComponent(g);
      return;
    }

    final FontMetrics fm = g.getFontMetrics();
    final int fontHeight = fm.getHeight();

    int lineNumber = ((clip.y + insets.top) / fontHeight) + 1;
    int y = fm.getAscent() + insets.top;
    if (y < clip.y) {
      y = lineNumber * fontHeight - (fontHeight - fm.getAscent());
    }
    final int ystart = y;
    int yend = y + clip.height + fontHeight;

    g.setColor(frameBgColor);
    g.fillRect(0, ystart - fontHeight, insets.left, yend - ystart);

    int prefixWidth = fm.stringWidth(prefix);
    // posio x
    final int lnxstart = insets.left - getLinePanelWidth();
    g.setColor(frameFgColor);

    while (y < yend) {
      g.setColor(prefixFgColor);
      g.drawString(prefix, lnxstart, y);
      g.setColor(frameFgColor);
      g.drawString(lineNumber + " ", lnxstart + prefixWidth, y);
      y += fontHeight;
      lineNumber++;
    }

    super.paintComponent(g);
  }

  /**
   * Consulta o prefico
   * 
   * @return o prefixo
   */
  public final String getPrefix() {
    return prefix;
  }

  /**
   * Ajuste do prefixo
   * 
   * @param prefix o prefixo
   */
  public final void setPrefix(String prefix) {
    this.prefix = (prefix == null ? "" : prefix);
  }

  /**
   * Construtor
   */
  public LinedTextArea() {
    super();
    setOpaque(false);
  }
}
