/*
 * $Id:$
 */

package csbase.client.algorithms.parameters;

import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

import csbase.logic.algorithms.parameters.BooleanParameter;

/**
 * Viso do {@link BooleanParameter Parmetro do Tipo Booleano}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class BooleanParameterView extends SimpleParameterView<Boolean> {

  /**
   * Cria a viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   * 
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro que  manipulado pela viso (No aceita
   *        {@code null}).
   * 
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public BooleanParameterView(Window window, BooleanParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   * 
   * @param parameter O parmetro que  manipulado pela viso (No aceita
   *        {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public BooleanParameterView(BooleanParameter parameter, Mode mode) {
    super(parameter, mode);

    updateViewContents();
    updateCapabilityView();
    updateVisibilyView();
  }

  /**
   * {@inheritDoc}
   */
  public boolean isNullable() {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public BooleanParameter getParameter() {
    return (BooleanParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createConfigurationComponent(Object... componentArgs) {
    return new BooleanConfigurationParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createReportComponent(Object... componentArgs) {
    return new BooleanReportParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void updateViewContents() {
    ((IBooleanParameterComponent) getComponent()).updateViewContents();
  }

  /**
   * Interface para booleanos.
   * 
   * @author Tecgraf/PUC-Rio
   */
  private interface IBooleanParameterComponent {
    /**
     * Atualiza o contedo exibido pela viso.
     */
    void updateViewContents();
  }

  /**
   * Componente para booleanos em modo report.
   * 
   * @author Tecgraf/PUC-Rio
   */
  private final class BooleanReportParameter extends JCheckBox implements
    IBooleanParameterComponent {

    /**
     * Construtor
     */
    BooleanReportParameter() {
      setToolTipText(getParameter().getDescription());
      super.setEnabled(false);
      updateViewContents();
    }

    /**
     * {@inheritDoc}.
     */
    @Override
    public void setEnabled(boolean enabled) {
      //Este mtodo no faz nada, pois este componente no pode ser habilitado.
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      Boolean value = getParameter().getValue();
      setSelected(value.booleanValue());
    }
  }

  /**
   * 
   * 
   * @author Tecgraf/PUC-Rio
   */
  private final class BooleanConfigurationParameter extends JPanel implements
    IBooleanParameterComponent {

    /**
     * Toggle.
     */
    private final JCheckBox checkbox;

    /**
     * Construtor
     */
    BooleanConfigurationParameter() {
      this.checkbox = new JCheckBox();
      this.checkbox.setToolTipText(getParameter().getDescription());
      this.checkbox.addActionListener(new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
          getParameter().toggleValue();
        }
      });
      setLayout(new BorderLayout());
      add(this.checkbox, BorderLayout.WEST);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void updateViewContents() {
      Boolean value = getParameter().getValue();
      checkbox.setSelected(value.booleanValue());
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean fillVerticalSpace() {
    return false;
  }
}
