package csbase.client.applications.algorithmsmanager.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import csbase.client.applications.algorithmsmanager.report.core.ReportDialog;
import csbase.client.applications.algorithmsmanager.report.core.TestRunner;
import csbase.client.applications.algorithmsmanager.report.core.TestSelectionDialog;
import csbase.client.applications.algorithmsmanager.report.implementations.AlgorithmManagerSubjectFactory;
import csbase.client.applications.algorithmsmanager.report.implementations.TestConfiguratorInvalid;
import csbase.client.applications.algorithmsmanager.report.implementations.TestMissingPlatform;
import csbase.client.applications.algorithmsmanager.report.implementations.TestOutdatedFlow;
import csbase.logic.Platform;

/**
 * Ao que dispara todos os testes disponveis no sistema
 *
 * @author Tecgraf/PUC-Rio
 */
public class RunTestsAction extends AlgorithmsManagerAction {

  /**
   * Construtor
   *
   * @param application a aplicao.
   */
  public RunTestsAction(AlgorithmsManager application) {
    super(application);
  }

  /**
   * Chama o runner para todos os testes cadastrados, para todas as fontes
   * possveis (todos os algoritmos) e abre a janela de relatrio. {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {

    List<ITest<?>> allTests = buildAllTests();

    ApplicationFrame frame = getApplication().getApplicationFrame();
    TestSelectionDialog selectionDialog =
      new TestSelectionDialog(allTests, getApplication().getLocale(),
        getApplication().getApplicationFrame());
    selectionDialog.setVisible(true);

    List<Boolean> selection = selectionDialog.getSelection();
    if (selection == null) {
      return;
    }

    List<ITest<?>> selectedTests = buildSelection(allTests, selection);

    AlgorithmManagerSubjectFactory subjectFactory =
      new AlgorithmManagerSubjectFactory(getApplication());

    TestRunner testRunner =
      new TestRunner(subjectFactory, getApplication().getApplicationFrame(),
        getApplication().getClassString(getClass(),
          "running.algorithms.tests.title"), getApplication().getClassString(
          getClass(), "running.algorithms.tests.message"));
    Map<ITest<?>, ITestResult<?>> map = testRunner.run(selectedTests);

    ReportDialog dialog =
      new ReportDialog(map, getApplication().getLocale(), frame);
    dialog.setVisible(true);
  }

  /**
   * Retorna todos os testes existentes
   *
   * @return Lista com todos os testes
   * @throws Exception Erro se no conseguir pegar as plataformas
   */
  private List<ITest<?>> buildAllTests() throws Exception {
    Frame frame = getApplication().getApplicationFrame();

    List<ITest<?>> allTests = new ArrayList<>();

    allTests.add(new TestOutdatedFlow(frame));
    allTests.add(new TestMissingPlatform(Platform.getAllPlatforms(), frame));
    allTests.add(new TestConfiguratorInvalid(frame));
    //    allTests.add(new TestParamterUsage(new SimpleConfiguratorSource(
    //      getApplication()), frame));

    return allTests;
  }

  /**
   * Monta a seleo dos testes a serem executados.
   *
   * @param allTests todos os testes disponveis.
   * @param selection a seleo da janela.
   * @return lista dos testes selecionados.
   */
  private List<ITest<?>> buildSelection(List<ITest<?>> allTests,
    List<Boolean> selection) {

    List<ITest<?>> selectedTests = new ArrayList<>();
    for (int i = 0; i < allTests.size(); i++) {
      if (selection.get(i)) {
        selectedTests.add(allTests.get(i));
      }
    }

    return selectedTests;
  }

}
