package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;

/**
 * Classe que testa se um parmetro est sendo usado por algum teste;
 *
 * @author Tecgraf/PUC-Rio
 */
@SuppressWarnings("rawtypes")
public class TestParamterUsage extends AbstractTest<Parameter> {

  /**
   * Lista dos algorithmos que deve ser varrida para encontrar algum que use o
   * parmetro
   */
  SimpleConfiguratorSource algorithms;

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return LNG.get("TestParamterUsage.name");
  }

  /** {@inheritDoc} */
  @Override
  public String getDescription() {
    return LNG.get("TestParamterUsage.description");
  }

  /**
   * Construtor
   * 
   * @param algorithms Lista de algoritmos
   * @param window janela que disparou o teste
   * */
  public TestParamterUsage(SimpleConfiguratorSource algorithms, Window window) {
    super(window, LNG.get("TestOutdatedFlow.task.title"), LNG
      .get("TestOutdatedFlow.task.message"));
    this.algorithms = algorithms;

  }

  /** {@inheritDoc} */

  @Override
  public Class<Parameter> getSubjectClass() {

    return Parameter.class;

  }

  /** {@inheritDoc} */
  @Override
  protected List<IResultMessage<Parameter>> doTest(Parameter subject) {

    List<IResultMessage<Parameter>> result = new ArrayList<>();

    for (SimpleAlgorithmConfigurator configurator : algorithms) {

      for (SimpleParameter sp : configurator.getSimpleParameters()) {
        if (sp.getClass().equals(subject.getClass())) {
          return result;
        }
      }
      for (HiddenParameter hp : configurator.getHiddenParameters()) {
        if (hp.getClass().equals(subject.getClass())) {
          return result;
        }
      }

      IResultMessage<Parameter> message =
        new ResultMessage<Parameter>(subject, TestStatus.ERROR,
          "Parameter never used");

      result.add(message);
    }

    return result;
  }

  /** {@inheritDoc} */
  @Override
  public String getSubjectName(Parameter subject) {
    return subject.getName();
  }
}
