/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.script;

import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.Priority;

/**
 * Implementa um comando no modificvel para ser utilizada no valor do elemento
 * &lt;expression&gt; que ser interpretado como um script para filtrar
 * comandos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ScriptCommand {

  /** Comando representado por esta instncia. */
  private CommandInfo command;
  /** Verso no modificvel da data de submisso do comando. */
  private ScriptDate submittedDate;

  /**
   * Construtor.
   * 
   * @param command comando a ser representado.
   */
  public ScriptCommand(CommandInfo command) {
    this.command = command;
    this.submittedDate = new ScriptDate(command.getSubmittedDate());
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getCpuPerc()}
   */
  public Double getCpu() {
    return command.getCpuPerc();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getDescription()}
   */
  public String getDescription() {
    return command.getDescription();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getId()}
   */
  public String getId() {
    return command.getId();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getPriority()}
   */
  public Priority getPriority() {
    return command.getPriority();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getProjectId()}
   */
  public Object getProjectId() {
    return command.getProjectId();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getRAMMemoryPerc()}
   */
  public Double getRam() {
    return command.getRAMMemoryPerc();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getSGAName()}
   */
  public String getSga() {
    return command.getSGAName();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getStatus()}
   */
  public CommandStatus getStatus() {
    return command.getStatus();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return a {@link ScriptDate data} de submisso do comando.
   */
  public ScriptDate getSubmission() {
    return submittedDate;
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getSwapMemoryPerc()}
   */
  public Double getSwap() {
    return command.getSwapMemoryPerc();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getTip()}
   */
  public String getTip() {
    return command.getTip();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getUserId()}
   */
  public Object getUserId() {
    return command.getUserId();
  }

  /**
   * Consulta a informao de {@link #command}.
   * 
   * @return {@link CommandInfo#getWallTimeSec()}
   */
  public int getWallTime() {
    return command.getWallTimeSec();
  }
}
