package csbase.client.applications.fileexchanger.actions;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;

/**
 * Ao para alternar visibilidade de colunas de detalhes de transferncia
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ToggleAdvancedColumnsVisibilityAction extends FileExchangerAction {

  /**
   * Construtor.
   * 
   * @param fileExchanger aplicao.
   */
  public ToggleAdvancedColumnsVisibilityAction(FileExchanger fileExchanger) {
    super(fileExchanger);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final FileExchanger fileExchanger = getApplication();
    final boolean isVisible = fileExchanger.isAdvancedColumnsVisible();
    fileExchanger.setAdvancedColumnsVisible(!isVisible);
  }
}
