/**
 * $Id$
 */
package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import javax.swing.AbstractAction;

import csbase.client.algorithms.AlgorithmHelpAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 *
 *
 * @author Tecgraf
 */
public class ShowAlgorithmHelpAction extends GraphElementAction {

  /**
   * Ao genrica para abrir o manual
   */
  AbstractAction action = null;

  /**
   * Cria a ao
   *
   * @param node N a ser consultado
   */
  protected ShowAlgorithmHelpAction(final GraphNode node) {
    super(node, ShowAlgorithmHelpAction.class.getName() + ".name",
      ApplicationImages.ICON_HELP_16);
    AlgorithmVersionInfo info = node.getAlgorithm().getLastVersion();
    action = new AlgorithmHelpAction(getParentWindow(), info);
    setEnabled(action.isEnabled());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent event) {
    action.actionPerformed(event);
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   *
   * @param workspace A rea de trabalho (No aceita {@code null}).
   *
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddNodePopupActionFilter(workspace) {

      @Override
      protected Action createAction(final GraphNode graphNode,
        final Point2D point) {
        return new ShowAlgorithmHelpAction(graphNode);
      }

    };
  }

}
