package csbase.client.applications.projectsmanager;

import java.util.Observable;

import tecgraf.javautils.gui.SwingThreadDispatcher;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.remote.ProjectAdminObserver;
import csbase.logic.AdministrationEvent;
import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectUserEvent;

/**
 * Esta classe observa o servio de administrao de projetos, invocando mtodos
 * da aplicao ProjectsManager quando necessrio, para manter a lista de
 * projetos da aplicao coerente com o sistema.
 * 
 * @author jnlopes
 * 
 */
public class ProjectCreationRemovalObserver extends
  AbstractProjectsManagerObserver {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public ProjectCreationRemovalObserver(final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(Observable o, Object arg) {
    if (o == null) {
      return;
    }

    if (!(o instanceof ProjectAdminObserver)
      || !(arg instanceof ProjectUserEvent)) {
      return;
    }

    final CommonProjectInfo cpi;
    final int type;
    if (arg instanceof ProjectUserEvent) {
      final ProjectUserEvent pue = (ProjectUserEvent) arg;
      cpi = (CommonProjectInfo) (pue).item;
      type = pue.type;
    }
    else {
      final AdministrationEvent ae = (AdministrationEvent) arg;
      cpi = (CommonProjectInfo) (ae).item;
      type = ae.type;
    }

    SwingThreadDispatcher.invokeLater(new Runnable() {
      @Override
      public void run() {
        final ProjectsManagerData pmd = projectsManager.getProject(cpi);
        if (type == ProjectUserEvent.CREATE) {
          if (pmd != null) {
            /*
             * Nota - Por se tratar de um evento de criao de projeto, e dois
             * projetos de mesmo nome e owner no podem existir, esta condio
             * s  atendida quando um projeto  criado pelo prprio
             * projectsmanager, e em seguida, este mesmo evento  capturado
             * aqui.
             */
            return;
          }
          addProject(cpi);
        }
        else if (type == ProjectUserEvent.DELETE) {
          if (pmd != null) {
            final ProjectSpaceAllocation psa = pmd.getProjectSpaceAllocation();
            if (psa == ProjectSpaceAllocation.ALLOCATED) {
              pmd
                .setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_DEALLOCATION);
            }
            else if (psa != ProjectSpaceAllocation.WAITING_DEALLOCATION) {
              projectsManager.removeProject(cpi);
            }
          }
        }
      }
    });
  }
}
