package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectGeneralAreaOccupationData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;

/**
 * Task que obtm informaes gerais sobre a ocupao da rea de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class GetGeneralSpaceUsageTask extends
  ProjectsManagerTask<ProjectGeneralAreaOccupationData> {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public GetGeneralSpaceUsageTask(final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    final DiskUsageServiceInterface dsi = ClientRemoteLocator.diskUsageService;
    final DiskOccupation occupation = dsi.getProjectOccupation();

    final double freeSpace = occupation.getFreeSpaceMb();
    final double occupiedSpace = occupation.getUsedSpaceMb();

    if (freeSpace < 0 || occupiedSpace < 0) {
      setResult(null);
      return;
    }

    final ProjectGeneralAreaOccupationData paod =
      new ProjectGeneralAreaOccupationData(freeSpace, occupiedSpace);

    setResult(paod);
  }

}
