package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGASet;

/**
 * Exibe o estado de um SGA/Cluster.<br/>
 * Estados de um SGA: Disponvel, Sem acesso ao disco, Reservado ou Inacessvel.
 * 
 * @see csbase.logic.SGASet.Status
 * 
 * @author Tecgraf
 */
public class StatusColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public StatusColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {
    return getString("status." + obj.getStatus().toString());
  }
}
