/**
 * $Id$
 */
package csbase.client.openbus;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.TimeZone;

import csbase.exception.CSBaseException;
import csbase.logic.Session;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.Authenticator;
import csbase.remote.ServerEntryPoint;

/**
 * Representa um autenticador de usurios no servidor atravs de uma credencial
 * do OpenBus.
 * 
 * @author Tecgraf/PUC-RIo
 */
public final class OpenBusAuthenticator implements Authenticator {

  /**
   * O token para autenticao no barramento.
   */
  final private OpenBusLoginToken token;

  /**
   * A locale escolhida pelo usurio.
   */
  final private Locale locale;

  /**
   * Cria o autenticador de usurios no servidor atravs de uma credencial do
   * OpenBus.
   * 
   * @param token O token.
   * @param locale A locale escolhida pelo usurio.
   */
  public OpenBusAuthenticator(OpenBusLoginToken token, Locale locale) {
    this.token = token;
    this.locale = locale;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Session authenticate(ServerEntryPoint server) throws CSBaseException {
    TimeZone tz = TimeZone.getDefault();
    try {
      return server.login(this.token, this.locale, tz);
    }
    catch (RemoteException e) {
      throw new CSBaseException(e);
    }
  }
}
