package csbase.client.preferences.editors;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Classe que encapsula o editor de um valor que armazena cor.
 * 
 * @author Tecgraf
 */
public class PVColorEditor extends PreferenceEditor<Color> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public PVColorEditor(PreferenceValue<Color> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    ColorButton button = new ColorButton(getValue());

    JColorChooser chooser = new JColorChooser();
    chooser.setPreviewPanel(new JLabel()); // removendo o painel de preview

    ActionListener ok = createOkAction(button, chooser);

    final JDialog dialog =
      JColorChooser.createDialog(button, "", true, chooser, ok, null);

    button.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        dialog.setVisible(true);
      }
    });

    button.setEnabled(isEditable());
    return button;
  }

  /**
   * Cria a ao usada no boto "Ok".
   * 
   * @param button - boto pai do dilogo de escolha da cor.
   * @param chooser - componente de escolha de cor.
   * @return ao do boto "ok".
   */
  private ActionListener createOkAction(final ColorButton button,
    final JColorChooser chooser) {
    return new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        Color c = chooser.getColor();
        setValue(c);
        notifyListeners();
        button.setColor(c);
      }
    };
  }

  /**
   * Boto que possui um retangulo pintado na cor que o usurio escolheu.
   * 
   * @author Tecgraf
   */
  private class ColorButton extends JButton {

    /** Cor escolhida pelo usurio. */
    private Color color;

    /**
     * Construtor padro.
     * 
     * @param color - cor escolhida pelo usurio.
     */
    ColorButton(Color color) {
      super(" ");
      this.color = color;
    }

    /**
     * Seta a cor que o usurio escolheu.
     * 
     * @param color - cor que o usurio escolheu.
     */
    void setColor(Color color) {
      this.color = color;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void paintComponent(Graphics g) {
      super.paintComponent(g);
      g.setColor(this.color);
      g.fillRect(5, 5, getWidth() - 10, getHeight() - 10);
    }

  }
}
