/*
 * $Id:$
 */

package csbase.client.project;

import java.awt.Cursor;

import javax.swing.JFrame;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

import csbase.client.desktop.DesktopFrame;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ProjectTreeWillExpandListener implements TreeWillExpandListener {

  /**
   * A rvore.
   */
  final private ProjectTreeModel treeModel;

  /**
   * {@inheritDoc}
   */
  final public void treeWillCollapse(final TreeExpansionEvent event) {
  }

  /**
   * {@inheritDoc}
   */
  final public void treeWillExpand(final TreeExpansionEvent event)
    throws ExpandVetoException {
    final TreePath path = event.getPath();
    final ProjectTreeNode node = (ProjectTreeNode) path.getLastPathComponent();
    final DesktopFrame dsk = DesktopFrame.getInstance();
    final JFrame frm = dsk.getDesktopFrame();
    frm.setCursor(new Cursor(Cursor.WAIT_CURSOR));
    try {
      treeModel.fireTreeWillChange(node.getTreePath());
      node.loadChildren(false);
      treeModel.fireTreeStructureChanged(path);
    }
    finally {
      frm.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }
  }

  /**
   * Construtor
   * 
   * @param treeModel o model da rvore
   */
  public ProjectTreeWillExpandListener(final ProjectTreeModel treeModel) {
    this.treeModel = treeModel;
  }
}
