/*
 * $Id$ 
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;

/**
 * Alterna entre ligar e desligar a auto-recarga do painel de log.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class AutoReloadAction extends AbstractLogFileAction {

  /**
   * Construtor
   * 
   * @param logPanel o painel de log associado a ao.
   */
  public AutoReloadAction(final LogPanel logPanel) {
    super(logPanel, ApplicationImages.ICON_REFRESH_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    LogPanelReloader reloader = getLogPanel().getReloader();
    if (reloader.isRunning()) {
      reloader.stop();
    }
    else {
      reloader.start();
    }   
  }
}