package csbase.client.util.sga;

import javax.swing.JFrame;

import csbase.logic.CommandSubmission;
import csbase.logic.CommonClientProject;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.validation.Validation;

/**
 * Dilogo de Execuo de Comando especfico para execuo de mltiplos fluxos.
 */
public class MultipleFlowCommandExecutionDialog extends CommandExecutionDialog {

  /** A lista comandos para submisso. */
  private MultipleCommandSubmission multipleSubmission;

  /**
   * Construtor.
   * 
   * @param parentFrame A janela que est requisitando este configurador (No
   *        pode ser nulo).
   * @param configurator O configurador do fluxo a ser executado.
   * @param project O projeto.
   * @param mappings O mapeamento dos parmetros para execuo de mltiplos
   *        fluxos.
   */
  public MultipleFlowCommandExecutionDialog(JFrame parentFrame,
    FlowAlgorithmConfigurator configurator, CommonClientProject project,
    String[][] mappings) {
    super(parentFrame, configurator, project);
    this.multipleSubmission = createSubmission(mappings);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Validation validateCommand() {
    return multipleSubmission.getValidation();
  }

  /**
   * Cria a lista de submisses mltiplas de fluxos.
   * 
   * @param paramTable o mapeamento dos parmetros.
   * @return a lista de submisses.
   */
  private MultipleCommandSubmission createSubmission(final String[][] paramTable) {
    final FlowAlgorithmConfigurator configurator =
      (FlowAlgorithmConfigurator) getConfigurator();
    MultipleCommandSubmission submission =
      CreateMultipleFlowSubmissionTask.runTask(this, paramTable, configurator);
    return submission;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void execute() {
    for (CommandSubmission submission : multipleSubmission) {
      submitCommand(submission);
    }
  }

}
