/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.exception.CSBaseException;
import csbase.logic.ClientProjectFile;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public final class UpdateFileDialog
extends DesktopComponentDialog {
    private static final String LNG_PREFIX = "UpdateFileDialog.";
    private ClientProjectFile file;
    private JTextField intervalField;
    private JButton stopButton;
    private JCheckBox notificationBox;

    public UpdateFileDialog(JFrame owner, ClientProjectFile file) {
        super((Window)owner, MessageFormat.format(LNG.get((String)"UpdateFileDialog.title"), file.getName()));
        this.file = file;
        this.createGui();
    }

    private void createGui() {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpdateFileDialog.this.close();
            }
        });
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("ins 10 0 0 0", "[][grow]", "[]10[]20[][]"));
        mainPanel.add((Component)new JLabel(LNG.get((String)"UpdateFileDialog.interval")), "gapleft 10");
        long interval = this.file.getUpdateInterval();
        String intervalText = "";
        if (interval > 0L) {
            intervalText = String.valueOf(interval);
        }
        this.intervalField = new JTextField(intervalText, 5);
        mainPanel.add((Component)this.intervalField, "grow x, split 2");
        mainPanel.add((Component)new JLabel(LNG.get((String)"UpdateFileDialog.seconds")), "gapright 10, wrap");
        this.notificationBox = new JCheckBox(LNG.get((String)"UpdateFileDialog.notification"));
        mainPanel.add((Component)this.notificationBox, "skip 1, gapright 10, wrap");
        mainPanel.add((Component)this.makeButtonPanel(), "gapleft 10, grow x, spanx");
        String text = "";
        text = interval > 0L ? MessageFormat.format(LNG.get((String)"UpdateFileDialog.update.status.user"), this.file.getUpdateUserLogin()) : LNG.get((String)"UpdateFileDialog.update.status.none");
        JLabel statusBar = new JLabel(text);
        statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        mainPanel.add((Component)statusBar, "grow x, spanx");
        this.getContentPane().add(mainPanel);
        this.setResizable(false);
        this.pack();
        this.center(this.getOwner());
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        String startButtonTitle = this.file.getUpdateInterval() == 0L ? LNG.get((String)"UpdateFileDialog.start") : LNG.get((String)"UpdateFileDialog.update");
        JButton startButton = (JButton)panel.add(new JButton(startButtonTitle));
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateFileDialog.this.handleStartAction()) {
                    UpdateFileDialog.this.close();
                }
            }
        });
        this.stopButton = (JButton)panel.add(new JButton(LNG.get((String)"UpdateFileDialog.stop")));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UpdateFileDialog.this.handleStopAction()) {
                    UpdateFileDialog.this.close();
                }
            }
        });
        JButton cancelButton = (JButton)panel.add(new JButton(LNG.get((String)"UpdateFileDialog.close")));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateFileDialog.this.close();
            }
        });
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{startButton, this.stopButton, cancelButton});
        this.getRootPane().setDefaultButton(startButton);
        if (this.file.getUpdateInterval() == 0L) {
            this.stopButton.setEnabled(false);
        } else {
            this.stopButton.setEnabled(true);
        }
        return panel;
    }

    private boolean handleStartAction() {
        int interval;
        String text = this.intervalField.getText();
        try {
            interval = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            interval = -1;
        }
        if (interval <= 0) {
            StandardDialogs.showErrorDialog((Component)this, (String)MessageFormat.format(LNG.get((String)"UpdateFileDialog.invalid.interval.title"), this.getTitle()), (String)LNG.get((String)"UpdateFileDialog.invalid.interval.message"));
            return false;
        }
        final int updateInterval = interval;
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException, CSBaseException {
                OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
                oap.init();
                byte[] chain = oap.makeChain();
                ClientRemoteLocator.projectService.startUpdate(UpdateFileDialog.this.file.getProjectId(), UpdateFileDialog.this.file.getPath(), (long)updateInterval, UpdateFileDialog.this.notificationBox.isSelected(), (Serializable)chain);
                UpdateFileDialog.this.file.setUpdateInfo(User.getLoggedUser().getLogin(), (long)updateInterval);
            }
        };
        if (task.execute(this.getOwner(), LNG.get((String)"UpdateFileDialog.task.title"), MessageFormat.format(LNG.get((String)"UpdateFileDialog.task.message"), this.file.getName()))) {
            this.stopButton.setEnabled(true);
            StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(LNG.get((String)"UpdateFileDialog.update.start.title"), this.file.getName()), (Object)LNG.get((String)"UpdateFileDialog.update.start.success.message"));
            return true;
        }
        StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(LNG.get((String)"UpdateFileDialog.update.start.title"), this.file.getName()), (Object)LNG.get((String)"UpdateFileDialog.update.start.error.message"));
        return false;
    }

    private boolean handleStopAction() {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws RemoteException {
                ClientRemoteLocator.projectService.stopUpdate(UpdateFileDialog.this.file.getProjectId(), UpdateFileDialog.this.file.getPath());
                UpdateFileDialog.this.file.setUpdateInfo(null, 0L);
            }
        };
        if (task.execute(this.getOwner(), LNG.get((String)"UpdateFileDialog.task.title"), MessageFormat.format(LNG.get((String)"UpdateFileDialog.task.message"), this.file.getName()))) {
            StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(LNG.get((String)"UpdateFileDialog.update.stop.title"), this.file.getName()), (Object)LNG.get((String)"UpdateFileDialog.update.stop.success.message"));
            this.stopButton.setEnabled(false);
            return true;
        }
        StandardDialogs.showInfoDialog((Component)this, (String)MessageFormat.format(LNG.get((String)"UpdateFileDialog.update.stop.title"), this.file.getName()), (Object)LNG.get((String)"UpdateFileDialog.update.stop.error.message"));
        return false;
    }
}

