package csbase.client.applications.algorithmsmanager;

/**
 * A interface <code>PropertiesListener</code> modela um listener para as
 * propriedades de um dado.
 * 
 * Esse listener avisa que uma determinada propriedade foi alterada.
 */
public interface PropertiesListener {
  /**
   * Nofifica que alguma das propriedades foram alteradas.
   * 
   * @param wasModified se true, alguma propriedade foi alterada, caso
   *        contrrio, todos os valores das propriedades esto iguais os valores
   *        originais
   */
  public void propertiesChanged(boolean wasModified);

}
