/*
 * $Id: DesktopLauncherEvent.java 109067 2010-08-13 20:54:14Z clinio $
 */

package csbase.client.applications.desktoplauncher;

import java.util.Date;

/**
 * Estrurura interna de evento do programa (armazenado internamente).
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DesktopLauncherEvent {

  /**
   * Direo
   */
  final private DesktopLauncherEventDirection direction;

  /**
   * Id do outro cliente envolvido
   */
  final private String otherId;

  /**
   * Indicativo de evento tratado.
   */
  final private boolean treated;

  /**
   * Classe do valor enviado no evento.
   */
  final private String className;

  /**
   * Valor (textual) enviado no evento.
   */
  final private String valueText;

  /**
   * Momento de cadastro do evento.
   */
  final private Date date;

  /**
   * Tipo
   */
  final private String type;

  /**
   * Consulta o atributo (ver documentao de {@link #className}).
   * 
   * @return o atributo.
   */
  public final String getClassName() {
    return className;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #date}).
   * 
   * @return o atributo.
   */
  public final Date getDate() {
    return date;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #direction}).
   * 
   * @return o atributo.
   */
  public final DesktopLauncherEventDirection getDirection() {
    return direction;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #otherId}).
   * 
   * @return o atributo.
   */
  public final String getOtherId() {
    return otherId;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #type}).
   * 
   * @return o atributo.
   */
  public String getType() {
    return type;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #valueText}).
   * 
   * @return o atributo.
   */
  public final String getValueText() {
    return valueText;
  }

  /**
   * Consulta o atributo (ver documentao de {@link #treated}).
   * 
   * @return o atributo.
   */
  public final boolean isTreated() {
    return treated;
  }

  /**
   * Construtor
   * 
   * @param treated indicativo de tratamento
   * @param direction direo
   * @param otherId id do outro client envolvido
   * @param type o tipo do evento.
   * @param className classe do valor passado (textual)
   * @param valueText valor passado (textual)
   */
  public DesktopLauncherEvent(final boolean treated,
    final DesktopLauncherEventDirection direction, final String otherId,
    final String type, final String className, final String valueText) {
    this.direction = direction;
    this.treated = treated;
    this.type = type;
    this.otherId = otherId;
    this.className = className;
    this.valueText = valueText;
    this.date = new Date();
  }
}
