package csbase.client.applications.flowapplication;

import javax.swing.JTree;
import javax.swing.tree.TreePath;

import tecgraf.javautils.gui.tree.Node;

/**
 * Classe de callback de processamento de um n que pode ser pr ou ps
 * processado; ou seja, o processamento  feito antes ou depois
 * (respectivamente) da visita aos filhos. Os mtodos de processamento recebem
 * sempre o <code>parentPath</code> (path do n-pai) que, no caso de
 * processamento do n raiz, vem com o valor <code>null</code>
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract public class NodeCallback {

  /**
   * mtodo de processamento (antes de passar para um novo n)
   * 
   * @param tree a rvore
   * @param parentPath o path do n pai (<b>pode ser <code>null</code> se
   *        <code>node</code> for o n raiz</b>)
   * @param node o n a ser processado
   */
  public void preProcess(final JTree tree, final TreePath parentPath,
    final Node node) {
  }

  /**
   * mtodo de processamento (depois de passar por todos os ns filhos)
   * 
   * @param tree a rvore
   * @param parentPath o path do n pai (<b>pode ser <code>null</code> se
   *        <code>node</code> for o n raiz</b>)
   * @param node o n a ser processado
   */
  public void postProcess(final JTree tree, final TreePath parentPath,
    final Node node) {
  }

}