package csbase.client.applications.flowapplication.multiflow;

import java.awt.GridBagLayout;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.Application;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel.ClientFileLocation;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;

/**
 * Janela de importao do arquivo de configurao para execuo de mltiplos
 * fluxos.
 */
public class ImportMultipleFlowConfigurationDialog extends
  AbstractMultipleFlowConfigurationDialog {

  /**
   * Indica se uma janela de visualizao do arquivo de configurao deve ser
   * mostrada.
   */
  private JCheckBox previewCSV;

  /**
   * Painel de seleo de arquivo de configurao.
   */
  private ClientFileChooserTextPanel chooserPanel;

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   * @param file O arquivo de configurao selecionado para a importao.
   */
  public ImportMultipleFlowConfigurationDialog(Application application,
    ClientFile file) {
    super(application, file);
  }

  /**
   * Construtor.
   * 
   * @param application a aplicao dona dessa janela.
   */
  public ImportMultipleFlowConfigurationDialog(Application application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JPanel createMainComponent() {
    JPanel contentPanel = new JPanel(new GridBagLayout());
    final Border border =
      BorderFactory.createEtchedBorder(EtchedBorder.LOWERED);
    contentPanel.setBorder(border);
    GBC gbc = new GBC().insets(5, 5, 5, 5).west().weighty(1);
    JLabel configurationFileLabel =
      new JLabel(
        getString("ImportMultipleFlowConfigurationDialog.configFileLabel"));
    contentPanel.add(configurationFileLabel, new GBC(gbc));

    chooserPanel =
      new ClientFileChooserTextPanel(this, CONFIGURATION_FILE_TYPE,
        ClientFileChooserType.OPEN, ClientFileChooserSelectionMode.FILES_ONLY,
        ClientFileLocation.ANY);
    contentPanel.add(chooserPanel, new GBC(gbc).gridx(1));

    previewCSV =
      new JCheckBox(
        getString("ImportMultipleFlowConfigurationDialog.previewCSVLabel"),
        true);
    contentPanel.add(previewCSV, new GBC(gbc).width(2).gridy(1));

    return contentPanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean validateFields() {
    setConfigurationFile(chooserPanel.getSelectedFile());
    return super.validateFields();
  }

  /**
   * Indica se a opo de mostrar uma janela de visualizao do arquivo de
   * configurao foi selecionada.
   * 
   * @return verdadeiro se a opo foi selecionada ou falso, caso contrrio.
   */
  public boolean showPreview() {
    return previewCSV.isSelected();
  }

}
