package csbase.client.applications.projectsmanager.proxy;

import java.util.ArrayList;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlock;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;

/**
 * Task que trata a incluso de comentrios pessoais ao histrico de projetos.
 * 
 * @author jnlopes
 */
public class AddPersonalCommentTask extends
  ProjectsManagerTask<List<ProjectsManagerData>> {

  /**
   * Informaes dos projetos.
   */
  private List<ProjectsManagerData> projects;

  /**
   * Comentrio a ser adicionado ao histrico.
   */
  private String personalComment;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param projects Informaes dos projetos.
   * @param personalComment Comentrio a ser adicionado ao histrico.
   */
  public AddPersonalCommentTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects, String personalComment) {
    super(projectsManager);
    this.projects = projects;
    this.personalComment = personalComment;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    List<ProjectsManagerData> list = new ArrayList<ProjectsManagerData>();
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
    for (int i = 0; i < projects.size(); i++) {
      CommonClientProject ccp =
        psi.openProject(projects.get(i).getProjectId(), false);
      ProjectHistoryBlock phb =
        new ProjectHistoryBlock(ProjectHistoryBlockType.PERSONAL_TEXT);
      phb.setUserComment("\n" + this.personalComment);
      try {
        ccp.getRoot().appendDescription(phb.getHistoryBlock());
      }
      catch (Exception e) {
        list.add(projects.get(i));
      }
    }
    setResult(list);
  }
}
