/**
 * $Id: MonitorPanel.java 152996 2014-05-30 13:26:14Z mjulia $
 */
package csbase.client.applications.serverdiagnostic.monitor;

import java.awt.GridBagLayout;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.serverdiagnostic.ServerDiagnostic;
import csbase.logic.diagnosticservice.Status;

/**
 * Painel com os estados dos recursos monitorados.
 * 
 * @author Tecgraf
 */
public class MonitorPanel extends ApplicationComponentPanel<ServerDiagnostic> {
  /**
   * Estado do barramento
   */
  Status busStatus;
  /**
   * Estado do CSFS
   */
  Status CSFSStatus;
  /**
   * Estados dos servios publicados
   */
  Status[] publishedServicesStatus;
  /**
   * Estado do disco
   */
  Status diskStatus;
  /**
   * Painel de estados
   */
  StatusListPanel statusPanel;

  /**
   * Construtor.
   * 
   * @param application a aplicao
   * @param busStatus estado do barramento
   * @param publishedServicesStatus estados dos servios publicados
   * @param CSFSStatus estado do CSFS
   * @param diskStatus estado do disco
   */
  public MonitorPanel(ServerDiagnostic application, Status busStatus,
    Status[] publishedServicesStatus, Status CSFSStatus, Status diskStatus) {
    super(application);
    this.busStatus = busStatus;
    this.publishedServicesStatus = publishedServicesStatus;
    this.CSFSStatus = CSFSStatus;
    this.diskStatus = diskStatus;
    buildInterface();
  }

  /**
   * Constri o painel.
   */
  private void buildInterface() {
    DefaultSwingRenderer defaultRenderer = new DefaultSwingRenderer();
    StatusGroupTreeNode statusTree = new StatusGroupTreeNode("root");
    if (busStatus != null) {
      StatusGroupTreeNode openbusGroupNode =
        statusTree.addStatusGroup(getString("openbus.group.label"));
      busStatus.setName(getString("openbus.conection.label"));
      openbusGroupNode.addStatus(busStatus, defaultRenderer);
      if (publishedServicesStatus != null && publishedServicesStatus.length > 0) {
        StatusGroupTreeNode publishedGroupNode =
          openbusGroupNode.addStatusGroup(getString("published.offers.label"));
        for (Status status : publishedServicesStatus) {
          publishedGroupNode.addStatus(status, defaultRenderer);
        }
      }
    }
    if (CSFSStatus != null) {
      CSFSStatus.setName(getString("csfs.conection.label"));
      statusTree.addStatusGroup(getString("csfs.group.label")).addStatus(
        CSFSStatus, defaultRenderer);
    }
    if (diskStatus != null) {
      diskStatus.setName(getString("disk.occupation.label"));
      statusTree.addStatusGroup(getString("disk.group.label")).addStatus(
        diskStatus, new DiskRenderer());
    }
    statusPanel = new StatusListPanel(this.getApplication(), statusTree);
    statusPanel.refreshPanel();
    this.setLayout(new GridBagLayout());
    this.add(statusPanel, new GBC(0, 0).both().insets(5, 5, 5, 5));
  }
}
