/*
 * $Id: GetChildFromPathTask.java 110326 2010-09-20 19:19:58Z clinio $
 */
package csbase.client.project.tasks;

import csbase.logic.ClientProjectFile;

/**
 * Classe que implementa a tarefa de consultar os filhos de um diretrio em um
 * projeto.
 */
public class GetChildFromPathTask extends CoreTask<ClientProjectFile> {

  /**
   * Arquivo consultado.
   */
  final private ClientProjectFile clientProjectFile;

  /**
   * O path nome
   */
  final private String[] path;

  /**
   * Construtor.
   * 
   * @param clientProjectFile o arquivo consultado.
   * @param path o nome do arquivo buscado (como filho de
   *        {@link #clientProjectFile}).
   */
  public GetChildFromPathTask(ClientProjectFile clientProjectFile,
    final String[] path) {
    this.clientProjectFile = clientProjectFile;
    this.path = path;
  }

  /**
   * {@inheritDoc}
   * 
   * Faz a chamada remota a getChild (lado cliente).
   */
  @Override
  protected void performTask() throws Exception {
    ClientProjectFile file = clientProjectFile.getChild(path);
    setResult(file);
  }

  /**
   * Mtodo de convenincia para chamada automtica da task.
   * 
   * @param parent diretrio pai
   * @param path path para o arquivo (diretrio filho)
   * @return o arquivo ou null
   */
  static final public ClientProjectFile runTask(final ClientProjectFile parent,
    final String[] path) {
    final GetChildFromPathTask task = new GetChildFromPathTask(parent, path);
    final boolean hasResult = task.execute();
    if (!hasResult) {
      return null;
    }

    final ClientProjectFile result = task.getResult();
    return result;
  }
}
