/*
 * $Id$
 */
package csbase.client.applications.imageviewer.actions.view;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;

/**
 * Ao de fecahr arquivo corrente.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ImageViewerZoomOutAction extends ImageViewerAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected ImageIcon getDefaultIcon() {
    return ApplicationImages.ICON_ZOOMOUT_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ImageViewerZoomOutAction(ImageViewer application) {
    super(application);
    final int mask = InputEvent.CTRL_DOWN_MASK;
    final KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_SUBTRACT, mask);
    putValue(Action.ACCELERATOR_KEY, ks);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) {
    final ImageViewer application = getApplication();
    application.setZoom(application.getZoom() / ImageViewer.ZOOM_STEP_FACTOR);
  }
}
