/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest.resources.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.rest.ExtendedResponseStatus;
import csbase.logic.applicationservice.ApplicationRegistry;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import tecgraf.javautils.core.lng.LNG;

@Path(value="v1/applications")
@Api(value="Applications")
public class ApplicationRestService {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @GET
    @ApiOperation(value="Get a list of available applications", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @Produces(value={"application/json"})
    public List<ApplicationResource> getApps() {
        ArrayList<ApplicationResource> app = new ArrayList<ApplicationResource>();
        ApplicationManager am = ApplicationManager.getInstance();
        for (ApplicationRegistry r : am.getAllApplicationRegistries()) {
            Client client = Client.getInstance();
            String name = r.getApplicationName(client.getDefaultLocale());
            String type = r.getId();
            ApplicationResource res = new ApplicationResource(name, type);
            app.add(res);
        }
        return app;
    }

    @GET
    @Path(value="/running")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a list of running applications", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    public List<RunningApplicationResource> getRunningApps() {
        ArrayList<RunningApplicationResource> app = new ArrayList<RunningApplicationResource>();
        ApplicationManager am = ApplicationManager.getInstance();
        Set<Map.Entry<String, Vector<ApplicationType>>> runningApps = am.getRunningApplications().entrySet();
        for (Map.Entry<String, Vector<ApplicationType>> r : runningApps) {
            String type = r.getKey();
            Locale locale = Client.getInstance().getDefaultLocale();
            ApplicationRegistry registry = am.getApplicationRegistry(type);
            String name = registry.getApplicationName(locale);
            RunningApplicationResource res = new RunningApplicationResource(name, type);
            ArrayList<String> ids = new ArrayList<String>();
            for (ApplicationType t : r.getValue()) {
                ids.add(t.getInstanceId());
            }
            res.setInstanceId(ids);
            if (ids.size() <= 0) continue;
            app.add(res);
        }
        return app;
    }

    @DELETE
    @Path(value="{instanceId}")
    @ApiOperation(value="Kill a running application", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=RESTApplicationInstance.class), @ApiResponse(code=404, message="Instance Id is not running", response=RESTError.class), @ApiResponse(code=500, message="The application threw an exception while shutting down.", response=RESTError.class)})
    public Response killRunningApp(@ApiParam(value="Application instance Id", required=true) @PathParam(value="instanceId") String instanceId, @ApiParam(value="Force kill application", required=false, example="true") @QueryParam(value="force") String force) {
        try {
            ApplicationManager manager = ApplicationManager.getInstance();
            ApplicationType appInstance = manager.getApplicationInstance(instanceId);
            if (appInstance == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RESTError(LNG.get((String)"application.manager.instance.not.found"))).build();
            }
            RESTApplicationInstance data = new RESTApplicationInstance(appInstance.getName(), instanceId);
            if (force != null && force.equals("true")) {
                manager.killApplication(appInstance);
            } else if (!appInstance.closeApplication()) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)data).build();
            }
            return Response.ok().entity((Object)data).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e.getLocalizedMessage();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RESTError(errMsg)).build();
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Run an application on the client", notes="This can only be done by the logged in user.", authorizations={@Authorization(value="oauth2")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=RESTApplicationInstance.class), @ApiResponse(code=404, message="The application type  was not found", response=RESTError.class), @ApiResponse(code=500, message="The application threw an exception while initializing.", response=RESTError.class)})
    public Response runApp(@ApiParam(value="Type of the application", required=true) @FormParam(value="type") String appType) {
        try {
            ApplicationManager manager = ApplicationManager.getInstance();
            ApplicationRegistry registry = manager.getApplicationRegistry(appType);
            if (registry == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RESTError("The application type '" + appType + "' not found")).build();
            }
            Object applicationType = manager.runApplication(appType);
            RESTApplicationInstance data = new RESTApplicationInstance(appType, ((ApplicationType)applicationType).getInstanceId());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)data).build();
        }
        catch (ApplicationException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
    }

    @POST
    @Path(value="{instanceId}/syncmessage")
    @Produces(value={"application/json"})
    @ApiOperation(value="Send a sync message to a running application", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=MessageResponse.class), @ApiResponse(code=400, message="Required input parameters cannot be validated", response=RESTError.class), @ApiResponse(code=404, message="Instance Id is not running", response=RESTError.class), @ApiResponse(code=412, message="The application is on invalid state for processing this type of message", response=RESTError.class), @ApiResponse(code=422, message="The application rejected the input parameters", response=RESTError.class), @ApiResponse(code=500, message="The application threw a runtime exception while processing the message.", response=RESTError.class)})
    public Response sendMessageSync(@ApiParam(value="Instance Id of the application", required=true) @PathParam(value="instanceId") String instanceId, @ApiParam(value="Message body", required=true) String body) {
        ApplicationManager manager = ApplicationManager.getInstance();
        ApplicationType appInstance = manager.getApplicationInstance(instanceId);
        if (appInstance == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RESTError(LNG.get((String)"application.manager.instance.not.found"))).build();
        }
        try {
            HashMap map;
            try {
                map = (HashMap)objectMapper.readValue(body, HashMap.class);
                if (map == null) {
                    throw new Exception("empty body");
                }
            }
            catch (Throwable ex) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError(LNG.get((String)"csbase.client.rest.server.notjason") + ": " + ex.getLocalizedMessage())).build();
            }
            if (!map.containsKey("type") && !(map.get("type") instanceof String)) {
                String errMsg = LNG.get((String)"csbase.client.rest.server.notype");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError(errMsg)).build();
            }
            if (!map.containsKey("senderId") && !(map.get("senderId") instanceof String)) {
                String errMsg = LNG.get((String)"csbase.client.rest.server.nosender");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError(errMsg)).build();
            }
            Object response = manager.sendSyncMessage(instanceId, (String)map.get("type"), map.get("value"), (String)map.get("senderId"));
            MessageResponse resp = new MessageResponse(instanceId, response);
            return Response.ok().entity((Object)resp).build();
        }
        catch (IllegalArgumentException ex) {
            return Response.status((Response.StatusType)ExtendedResponseStatus.UNPROCESSABLE_ENTITY).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
        catch (IllegalStateException ex) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
        catch (Throwable ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
    }

    @POST
    @Path(value="{appid}/asyncmessage")
    @Produces(value={"application/json"})
    @ApiOperation(value="Send an async message to a running application", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=400, message="Required input parameters cannot be validated", response=RESTError.class), @ApiResponse(code=404, message="Instance Id is not running", response=RESTError.class), @ApiResponse(code=412, message="The application is on invaid state for processing this type of message", response=RESTError.class), @ApiResponse(code=422, message="The application rejected the input parameters", response=RESTError.class), @ApiResponse(code=500, message="The application threw a runtime exception while processing the message.", response=RESTError.class)})
    public Response sendMessageAsync(@ApiParam(value="Instance Id of the application", required=true) @PathParam(value="appid") String instanceId, @ApiParam(value="Message body", required=true) String body) {
        ApplicationType applicationInstance = ApplicationManager.getInstance().getApplicationInstance(instanceId);
        if (applicationInstance == null) {
            RESTError restErr = new RESTError(LNG.get((String)"application.manager.instance.not.found"));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)restErr).build();
        }
        try {
            HashMap map;
            try {
                map = (HashMap)objectMapper.readValue(body, HashMap.class);
                if (map == null) {
                    throw new Exception("empty body");
                }
            }
            catch (Throwable ex) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError(LNG.get((String)"csbase.client.rest.server.notjason") + ": " + ex.getLocalizedMessage())).build();
            }
            if (!map.containsKey("type") && !(map.get("type") instanceof String)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError(LNG.get((String)"csbase.client.rest.server.notype"))).build();
            }
            if (!map.containsKey("senderId") && !(map.get("senderId") instanceof String)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError(LNG.get((String)"csbase.client.rest.server.nosender"))).build();
            }
            if (instanceId.equals("broadcast")) {
                ApplicationManager.getInstance().broadcastAsyncMessage((String)map.get("type"), map.get("value"), (String)map.get("senderId"));
            } else {
                ApplicationManager.getInstance().sendAsyncMessage(instanceId, (String)map.get("type"), map.get("value"), (String)map.get("senderId"));
            }
            return Response.ok().entity((Object)new MessageResponse(instanceId, "")).build();
        }
        catch (IllegalArgumentException ex) {
            return Response.status((Response.StatusType)ExtendedResponseStatus.UNPROCESSABLE_ENTITY).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
        catch (IllegalStateException ex) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
        catch (Throwable ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RESTError(ex.getLocalizedMessage())).build();
        }
    }

    @POST
    @Path(value="register")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Register an external application ", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="The application threw a runtime exception while registering service.", response=RESTError.class)})
    public Response register(@ApiParam(value="Type of the application to be registered", required=true) @FormParam(value="type") String appType, @ApiParam(value="The callback URL for handling messages", required=true) @FormParam(value="uri") String uri) {
        try {
            if (uri == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError("Callback URI is null")).build();
            }
            if (appType == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RESTError("Application type is null")).build();
            }
            ApplicationManager manager = ApplicationManager.getInstance();
            String appId = manager.registerExternalApplication(uri, appType);
            return Response.ok().entity((Object)appId).build();
        }
        catch (Throwable ex) {
            RESTError restError = new RESTError(ex.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)restError).build();
        }
    }

    @DELETE
    @Path(value="{appId}/unregister")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Unregister an external application ", notes="This can only be done by the logged in user.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Token (Bearer $TOKEN)", dataType="string", required=true, paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="The application threw a runtime exception while registering service.", response=RESTError.class)})
    public Response unregister(@ApiParam(value="The application instance ID to be unregistered", required=true) @PathParam(value="appId") String appId) {
        try {
            ApplicationManager manager = ApplicationManager.getInstance();
            manager.unregisterExternalApplication(appId);
            return Response.ok().entity((Object)appId).build();
        }
        catch (Throwable ex) {
            RESTError restError = new RESTError(ex.getLocalizedMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)restError).build();
        }
    }

    public static final class RESTError {
        private final String error;

        public RESTError(String error) {
            this.error = error;
        }

        @ApiModelProperty(value="The returned error description", required=true)
        public String getError() {
            return this.error;
        }
    }

    public static final class RESTApplicationInstance {
        private final String type;
        private final String instanceId;

        public RESTApplicationInstance(String type, String instanceId) {
            this.type = type;
            this.instanceId = instanceId;
        }

        @ApiModelProperty(value="The application type", required=true)
        public String getType() {
            return this.type;
        }

        @ApiModelProperty(value="The application instance ID", required=true)
        public String getInstanceId() {
            return this.instanceId;
        }
    }

    public static final class MessageResponse {
        private final String instanceId;
        private final Object response;

        public MessageResponse(String instanceId, Object response) {
            this.instanceId = instanceId;
            this.response = response;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public Object getResponse() {
            return this.response;
        }
    }

    @ApiModel(value="test")
    public static final class RunningApplicationResource {
        private String name;
        private String type;
        private List<String> instanceId;

        @ApiModelProperty(value="The name of the application", required=true)
        public String getName() {
            return this.name;
        }

        @ApiModelProperty(value="The list of application instances Ids", required=true)
        public List<String> getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(List<String> instanceId) {
            this.instanceId = instanceId;
        }

        @ApiModelProperty(value="The application type", required=true)
        public String getType() {
            return this.type;
        }

        public RunningApplicationResource(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static final class ApplicationResource {
        private String name;
        private String type;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public ApplicationResource(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

