/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache;

import csbase.client.util.IFilter;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CommandsFilter
implements IFilter<CommandInfo> {
    private Collection<CommandStatus> allowedStatuses;

    public CommandsFilter() {
        this(true, CommandStatus.values());
    }

    public CommandsFilter(CommandStatus ... statuses) {
        this(true, statuses);
    }

    public CommandsFilter(boolean in, CommandStatus ... statuses) {
        if (null == statuses || 0 == statuses.length) {
            throw new IllegalArgumentException("Array de status de comando vazio ou nulo.");
        }
        HashSet<CommandStatus> allowedStatusesHashSet = new HashSet<CommandStatus>();
        if (in) {
            for (CommandStatus aStatus : statuses) {
                allowedStatusesHashSet.add(aStatus);
            }
        } else {
            for (CommandStatus aStatus : CommandStatus.values()) {
                allowedStatusesHashSet.add(aStatus);
            }
            for (CommandStatus aStatus : statuses) {
                allowedStatusesHashSet.remove(aStatus);
            }
        }
        this.allowedStatuses = Collections.unmodifiableCollection(allowedStatusesHashSet);
    }

    public final Collection<CommandStatus> getAllowedStatus() {
        return this.allowedStatuses;
    }

    @Override
    public final boolean accept(CommandInfo cmd) {
        return this.allowedStatuses.contains(cmd.getStatus()) && this.acceptCommand(cmd);
    }

    protected boolean acceptCommand(CommandInfo cmd) {
        return true;
    }
}

